/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic.impl;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.impl.Messages;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLRelationship;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SetDefaultOnColumnWithNoDefaultCritic
extends CriticAndSettings {
    public SetDefaultOnColumnWithNoDefaultCritic() {
        super(CriticAndSettings.StarterPlatformTypes.GENERIC.getName(), Messages.getString("SetDefaultOnColumnWithNoDefaultCritic.name"));
    }

    @Override
    public List<Criticism> criticize(Object subject) {
        SQLRelationship.UpdateDeleteRule updateRule;
        if (!(subject instanceof SQLRelationship.ColumnMapping)) {
            return Collections.emptyList();
        }
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        SQLRelationship.ColumnMapping cm = (SQLRelationship.ColumnMapping)subject;
        SQLRelationship.UpdateDeleteRule deleteRule = cm.getParent().getDeleteRule();
        SQLColumn fkcol = cm.getFkColumn();
        if (deleteRule == SQLRelationship.UpdateDeleteRule.SET_DEFAULT && (fkcol.getDefaultValue() == null || fkcol.getDefaultValue().length() == 0)) {
            criticisms.add(new Criticism(subject, Messages.getString("SetDefaultOnColumnWithNoDefaultCritic.deleteRuleCriticism", cm.getParent().getName(), fkcol.getName()), this, new CriticFix[0]));
        }
        if ((updateRule = cm.getParent().getUpdateRule()) == SQLRelationship.UpdateDeleteRule.SET_DEFAULT && (fkcol.getDefaultValue() == null || fkcol.getDefaultValue().length() == 0)) {
            criticisms.add(new Criticism(subject, Messages.getString("SetDefaultOnColumnWithNoDefaultCritic.updateRuleCriticism", cm.getParent().getName(), fkcol.getName()), this, new CriticFix[0]));
        }
        return criticisms;
    }
}

