/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.selectvalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.lineage.FieldnameLineage;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.selectvalues.Messages;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValues;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectValuesMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] selectName;
    private String[] selectRename;
    private int[] selectLength;
    private int[] selectPrecision;
    private boolean selectingAndSortingUnspecifiedFields;
    private String[] deleteName;
    private SelectMetadataChange[] meta;

    public String[] getDeleteName() {
        return this.deleteName;
    }

    public void setDeleteName(String[] deleteName) {
        this.deleteName = deleteName;
    }

    public int[] getSelectLength() {
        return this.selectLength;
    }

    public void setSelectLength(int[] selectLength) {
        this.selectLength = selectLength;
    }

    public String[] getSelectName() {
        return this.selectName;
    }

    public void setSelectName(String[] selectName) {
        this.selectName = selectName;
    }

    public int[] getSelectPrecision() {
        return this.selectPrecision;
    }

    public void setSelectPrecision(int[] selectPrecision) {
        this.selectPrecision = selectPrecision;
    }

    public String[] getSelectRename() {
        return this.selectRename;
    }

    public void setSelectRename(String[] selectRename) {
        this.selectRename = selectRename;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields, int nrremove, int nrmeta) {
        this.selectName = new String[nrfields];
        this.selectRename = new String[nrfields];
        this.selectLength = new int[nrfields];
        this.selectPrecision = new int[nrfields];
        this.deleteName = new String[nrremove];
        this.meta = new SelectMetadataChange[nrmeta];
    }

    @Override
    public Object clone() {
        int i;
        SelectValuesMeta retval = (SelectValuesMeta)super.clone();
        int nrfields = this.selectName.length;
        int nrremove = this.deleteName.length;
        int nrmeta = this.meta.length;
        retval.allocate(nrfields, nrremove, nrmeta);
        for (i = 0; i < nrfields; ++i) {
            retval.selectName[i] = this.selectName[i];
            retval.selectRename[i] = this.selectRename[i];
            retval.selectLength[i] = this.selectLength[i];
            retval.selectPrecision[i] = this.selectPrecision[i];
        }
        for (i = 0; i < nrremove; ++i) {
            retval.deleteName[i] = this.deleteName[i];
        }
        for (i = 0; i < nrmeta; ++i) {
            retval.getMeta()[i] = this.meta[i].clone();
        }
        return retval;
    }

    private void readData(Node step) throws KettleXMLException {
        try {
            Node line;
            int i;
            Node fields = XMLHandler.getSubNode((Node)step, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            int nrremove = XMLHandler.countNodes((Node)fields, (String)"remove");
            int nrmeta = XMLHandler.countNodes((Node)fields, (String)"meta");
            this.allocate(nrfields, nrremove, nrmeta);
            for (i = 0; i < nrfields; ++i) {
                line = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.selectName[i] = XMLHandler.getTagValue((Node)line, (String)"name");
                this.selectRename[i] = XMLHandler.getTagValue((Node)line, (String)"rename");
                this.selectLength[i] = Const.toInt((String)XMLHandler.getTagValue((Node)line, (String)"length"), (int)-2);
                this.selectPrecision[i] = Const.toInt((String)XMLHandler.getTagValue((Node)line, (String)"precision"), (int)-2);
            }
            this.selectingAndSortingUnspecifiedFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fields, (String)"select_unspecified"));
            for (i = 0; i < nrremove; ++i) {
                line = XMLHandler.getSubNodeByNr((Node)fields, (String)"remove", (int)i);
                this.deleteName[i] = XMLHandler.getTagValue((Node)line, (String)"name");
            }
            for (i = 0; i < nrmeta; ++i) {
                Node metaNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"meta", (int)i);
                this.meta[i] = new SelectMetadataChange(metaNode);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("SelectValuesMeta.Exception.UnableToReadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        int nrfields = 0;
        int nrremove = 0;
        int nrmeta = 0;
        this.allocate(nrfields, nrremove, nrmeta);
        for (i = 0; i < nrfields; ++i) {
            this.selectName[i] = "fieldname" + (i + 1);
            this.selectRename[i] = "";
            this.selectLength[i] = -2;
            this.selectPrecision[i] = -2;
        }
        for (i = 0; i < nrremove; ++i) {
            this.deleteName[i] = "fieldname" + (i + 1);
        }
        for (i = 0; i < nrmeta; ++i) {
            this.meta[i] = new SelectMetadataChange("fieldname" + (i + 1), "", 0, -2, -2, -1, null, null, null, null);
        }
    }

    public void getSelectFields(RowMetaInterface inputRowMeta, String name) throws KettleStepException {
        if (this.selectName != null && this.selectName.length > 0) {
            RowMeta row = new RowMeta();
            for (int i = 0; i < this.selectName.length; ++i) {
                ValueMetaInterface v = inputRowMeta.searchValueMeta(this.selectName[i]);
                if (v == null) continue;
                if (!(v = v.clone()).getName().equals(this.selectRename[i]) && this.selectRename[i] != null && this.selectRename[i].length() > 0) {
                    v.setName(this.selectRename[i]);
                    v.setOrigin(name);
                }
                if (this.selectLength[i] != -2) {
                    v.setLength(this.selectLength[i]);
                    v.setOrigin(name);
                }
                if (this.selectPrecision[i] != -2) {
                    v.setPrecision(this.selectPrecision[i]);
                    v.setOrigin(name);
                }
                row.addValueMeta(v);
            }
            if (this.selectingAndSortingUnspecifiedFields) {
                ArrayList<String> extra = new ArrayList<String>();
                for (int i = 0; i < inputRowMeta.size(); ++i) {
                    String fieldName = inputRowMeta.getValueMeta(i).getName();
                    if (Const.indexOfString((String)fieldName, (String[])this.selectName) >= 0) continue;
                    extra.add(fieldName);
                }
                Collections.sort(extra);
                for (String fieldName : extra) {
                    ValueMetaInterface extraValue = inputRowMeta.searchValueMeta(fieldName);
                    row.addValueMeta(extraValue);
                }
            }
            inputRowMeta.clear();
            inputRowMeta.addRowMeta((RowMetaInterface)row);
        }
    }

    public void getDeleteFields(RowMetaInterface inputRowMeta) throws KettleStepException {
        if (this.deleteName != null && this.deleteName.length > 0) {
            for (int i = 0; i < this.deleteName.length; ++i) {
                try {
                    inputRowMeta.removeValueMeta(this.deleteName[i]);
                    continue;
                }
                catch (KettleValueException e) {
                    throw new KettleStepException((Throwable)e);
                }
            }
        }
    }

    public void getMetadataFields(RowMetaInterface inputRowMeta, String name) {
        if (this.meta != null && this.meta.length > 0) {
            for (int i = 0; i < this.meta.length; ++i) {
                SelectMetadataChange metaChange = this.meta[i];
                int idx = inputRowMeta.indexOfValue(metaChange.getName());
                if (idx < 0) continue;
                ValueMetaInterface v = inputRowMeta.getValueMeta(idx);
                if (!v.getName().equals(metaChange.getRename()) && !Const.isEmpty((String)metaChange.getRename())) {
                    v.setName(metaChange.getRename());
                    v.setOrigin(name);
                }
                if (metaChange.getType() != 0 && v.getType() != metaChange.getType()) {
                    v.setType(metaChange.getType());
                    v.setStorageType(0);
                }
                if (metaChange.getLength() != -2) {
                    v.setLength(metaChange.getLength());
                    v.setOrigin(name);
                }
                if (metaChange.getPrecision() != -2) {
                    v.setPrecision(metaChange.getPrecision());
                    v.setOrigin(name);
                }
                if (metaChange.getStorageType() >= 0) {
                    v.setStorageType(metaChange.getStorageType());
                    v.setOrigin(name);
                }
                if (!Const.isEmpty((String)metaChange.getConversionMask())) {
                    v.setConversionMask(metaChange.getConversionMask());
                    v.setOrigin(name);
                }
                if (!Const.isEmpty((String)metaChange.getDecimalSymbol())) {
                    v.setDecimalSymbol(metaChange.getDecimalSymbol());
                    v.setOrigin(name);
                }
                if (!Const.isEmpty((String)metaChange.getGroupingSymbol())) {
                    v.setGroupingSymbol(metaChange.getGroupingSymbol());
                    v.setOrigin(name);
                }
                if (Const.isEmpty((String)metaChange.getCurrencySymbol())) continue;
                v.setCurrencySymbol(metaChange.getCurrencySymbol());
                v.setOrigin(name);
            }
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        this.getSelectFields(inputRowMeta, name);
        this.getDeleteFields(inputRowMeta);
        this.getMetadataFields(inputRowMeta, name);
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <fields>");
        for (i = 0; i < this.selectName.length; ++i) {
            retval.append("      <field>");
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.selectName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"rename", (String)this.selectRename[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.selectLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.selectPrecision[i]));
            retval.append("      </field>");
        }
        retval.append("        ").append(XMLHandler.addTagValue((String)"select_unspecified", (boolean)this.selectingAndSortingUnspecifiedFields));
        for (i = 0; i < this.deleteName.length; ++i) {
            retval.append("      <remove>");
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.deleteName[i]));
            retval.append("      </remove>");
        }
        for (i = 0; i < this.meta.length; ++i) {
            retval.append(this.meta[i].getXML());
        }
        retval.append("    </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            int nrremove = rep.countNrStepAttributes(id_step, "remove_name");
            int nrmeta = rep.countNrStepAttributes(id_step, "meta_name");
            this.allocate(nrfields, nrremove, nrmeta);
            for (i = 0; i < nrfields; ++i) {
                this.selectName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.selectRename[i] = rep.getStepAttributeString(id_step, i, "field_rename");
                this.selectLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.selectPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
            }
            this.selectingAndSortingUnspecifiedFields = rep.getStepAttributeBoolean(id_step, "select_unspecified");
            for (i = 0; i < nrremove; ++i) {
                this.deleteName[i] = rep.getStepAttributeString(id_step, i, "remove_name");
            }
            for (i = 0; i < nrmeta; ++i) {
                this.meta[i] = new SelectMetadataChange();
                this.meta[i].setName(rep.getStepAttributeString(id_step, i, "meta_name"));
                this.meta[i].setRename(rep.getStepAttributeString(id_step, i, "meta_rename"));
                this.meta[i].setType((int)rep.getStepAttributeInteger(id_step, i, "meta_type"));
                this.meta[i].setLength((int)rep.getStepAttributeInteger(id_step, i, "meta_length"));
                this.meta[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, "meta_precision"));
                this.meta[i].setStorageType(ValueMeta.getStorageType((String)rep.getStepAttributeString(id_step, i, "meta_storage_type")));
                this.meta[i].setConversionMask(rep.getStepAttributeString(id_step, i, "meta_conversion_mask"));
                this.meta[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, "meta_decimal_symbol"));
                this.meta[i].setGroupingSymbol(rep.getStepAttributeString(id_step, i, "meta_grouping_symbol"));
                this.meta[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, "meta_currency_symbol"));
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("SelectValuesMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            int i;
            for (i = 0; i < this.selectName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.selectName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_rename", this.selectRename[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", this.selectLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", this.selectPrecision[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "select_unspecified", this.selectingAndSortingUnspecifiedFields);
            for (i = 0; i < this.deleteName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "remove_name", this.deleteName[i]);
            }
            for (i = 0; i < this.meta.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_name", this.meta[i].getName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_rename", this.meta[i].getRename());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_type", this.meta[i].getType());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_length", this.meta[i].getLength());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_precision", this.meta[i].getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_storage_type", ValueMeta.getStorageTypeCode((int)this.meta[i].getStorageType()));
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_conversion_mask", this.meta[i].getConversionMask());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_decimal_symbol", this.meta[i].getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_grouping_symbol", this.meta[i].getGroupingSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_currency_symbol", this.meta[i].getCurrencySymbol());
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("SelectValuesMeta.Exception.UnableToSaveStepInfoToRepository") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        boolean error_found;
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            int i;
            cr = new CheckResult(1, Messages.getString("SelectValuesMeta.CheckResult.StepReceivingFields", prev.size() + ""), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            error_found = false;
            for (i = 0; i < this.selectName.length; ++i) {
                int idx = prev.indexOfValue(this.selectName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.selectName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = Messages.getString("SelectValuesMeta.CheckResult.SelectedFieldsNotFound") + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, Messages.getString("SelectValuesMeta.CheckResult.AllSelectedFieldsFound"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            if (this.selectName.length > 0) {
                for (i = 0; i < prev.size(); ++i) {
                    ValueMetaInterface pv = prev.getValueMeta(i);
                    int idx = Const.indexOfString((String)pv.getName(), (String[])this.selectName);
                    if (idx >= 0) continue;
                    error_message = error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                    error_found = true;
                }
                if (error_found) {
                    error_message = Messages.getString("SelectValuesMeta.CheckResult.FieldsNotFound") + Const.CR + Const.CR + error_message;
                    cr = new CheckResult(2, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(1, Messages.getString("SelectValuesMeta.CheckResult.AllSelectedFieldsFound2"), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            error_message = "";
            error_found = false;
            for (i = 0; i < this.deleteName.length; ++i) {
                int idx = prev.indexOfValue(this.deleteName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.deleteName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = Messages.getString("SelectValuesMeta.CheckResult.DeSelectedFieldsNotFound") + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, Messages.getString("SelectValuesMeta.CheckResult.AllDeSelectedFieldsFound"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            error_message = "";
            error_found = false;
            for (i = 0; i < this.meta.length; ++i) {
                int idx = prev.indexOfValue(this.meta[i].getName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.meta[i].getName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = Messages.getString("SelectValuesMeta.CheckResult.MetadataFieldsNotFound") + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, Messages.getString("SelectValuesMeta.CheckResult.AllMetadataFieldsFound"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, Messages.getString("SelectValuesMeta.CheckResult.FieldsNotFound2"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("SelectValuesMeta.CheckResult.StepReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("SelectValuesMeta.CheckResult.NoInputReceivedError"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        int[] cnt = new int[this.selectName.length];
        error_found = false;
        String error_message = "";
        for (int i = 0; i < this.selectName.length; ++i) {
            cnt[i] = 0;
            for (int j = 0; j < this.selectName.length; ++j) {
                if (!this.selectName[i].equals(this.selectName[j])) continue;
                int n = i;
                cnt[n] = cnt[n] + 1;
            }
            if (cnt[i] <= 1) continue;
            if (!error_found) {
                error_message = Messages.getString("SelectValuesMeta.CheckResult.DuplicateFieldsSpecified") + Const.CR;
            } else {
                error_found = true;
            }
            error_message = error_message + Messages.getString("SelectValuesMeta.CheckResult.OccurentRow", i + " : " + this.selectName[i] + "  (" + cnt[i]) + Const.CR;
            error_found = true;
        }
        if (error_found) {
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SelectValues(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SelectValuesData();
    }

    public boolean isSelectingAndSortingUnspecifiedFields() {
        return this.selectingAndSortingUnspecifiedFields;
    }

    public void setSelectingAndSortingUnspecifiedFields(boolean selectingAndSortingUnspecifiedFields) {
        this.selectingAndSortingUnspecifiedFields = selectingAndSortingUnspecifiedFields;
    }

    public SelectMetadataChange[] getMeta() {
        return this.meta;
    }

    public void setMeta(SelectMetadataChange[] meta) {
        this.meta = meta;
    }

    public List<FieldnameLineage> getFieldnameLineage() {
        String output;
        String input;
        int i;
        ArrayList<FieldnameLineage> lineages = new ArrayList<FieldnameLineage>();
        for (i = 0; i < this.getSelectName().length; ++i) {
            input = this.getSelectName()[i];
            output = this.getSelectRename()[i];
            if (Const.isEmpty((String)output) || input.equalsIgnoreCase(output)) continue;
            lineages.add(new FieldnameLineage(input, output));
        }
        for (i = 0; i < this.getMeta().length; ++i) {
            input = this.getMeta()[i].getName();
            output = this.getMeta()[i].getRename();
            if (Const.isEmpty((String)output) || input.equalsIgnoreCase(output)) continue;
            int idx = Const.indexOfString((String)input, (String[])this.getSelectRename());
            if (idx < 0) {
                lineages.add(new FieldnameLineage(input, output));
                continue;
            }
            FieldnameLineage lineage = FieldnameLineage.findFieldnameLineageWithInput(lineages, input);
            lineage.setOutputFieldname(output);
        }
        return lineages;
    }
}

