/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.execprocess;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.execprocess.ExecProcessData;
import org.pentaho.di.trans.steps.execprocess.ExecProcessMeta;
import org.pentaho.di.trans.steps.execprocess.Messages;

public class ExecProcess
extends BaseStep
implements StepInterface {
    private ExecProcessMeta meta;
    private ExecProcessData data;

    public ExecProcess(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block11: {
            this.meta = (ExecProcessMeta)smi;
            this.data = (ExecProcessData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.previousRowMeta = this.getInputRowMeta().clone();
                this.data.NrPrevFields = this.data.previousRowMeta.size();
                this.data.outputRowMeta = this.data.previousRowMeta;
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                if (Const.isEmpty((String)this.meta.getProcessField())) {
                    this.logError(Messages.getString("ExecProcess.Error.ProcessFieldMissing"));
                    throw new KettleException(Messages.getString("ExecProcess.Error.ProcessFieldMissing"));
                }
                if (this.data.indexOfProcess < 0) {
                    this.data.indexOfProcess = this.data.previousRowMeta.indexOfValue(this.meta.getProcessField());
                    if (this.data.indexOfProcess < 0) {
                        this.logError(Messages.getString("ExecProcess.Exception.CouldnotFindField") + "[" + this.meta.getProcessField() + "]");
                        throw new KettleException(Messages.getString("ExecProcess.Exception.CouldnotFindField", this.meta.getProcessField()));
                    }
                }
            }
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            for (int i = 0; i < this.data.NrPrevFields; ++i) {
                outputRow[i] = r[i];
            }
            String processString = this.data.previousRowMeta.getString(r, this.data.indexOfProcess);
            try {
                if (Const.isEmpty((String)processString)) {
                    throw new KettleException(Messages.getString("ExecProcess.ProcessEmpty"));
                }
                String resultString = this.execProcess(processString);
                outputRow[this.data.NrPrevFields] = resultString;
                int rowIndex = this.data.NrPrevFields;
                ++rowIndex;
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), Messages.getString("ExecProcess.LineNumber", this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)), new Object[0]);
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("ExecProcess.ErrorInStepRunning") + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block11;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "ExecProcess001");
            }
        }
        return true;
    }

    private String execProcess(String process) throws KettleException {
        String retval = null;
        Process p = null;
        try {
            try {
                String line;
                p = Runtime.getRuntime().exec(process);
                BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
                StringBuffer retvalBuff = new StringBuffer();
                while ((line = b.readLine()) != null) {
                    retvalBuff.append(line);
                }
                retval = retvalBuff.toString();
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            Object var8_8 = null;
            if (p != null) {
                p.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (p != null) {
                p.destroy();
            }
            throw throwable;
        }
        return retval;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecProcessMeta)smi;
        this.data = (ExecProcessData)sdi;
        if (super.init(smi, sdi)) {
            if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                this.log.logError(this.toString(), Messages.getString("ExecProcess.Error.ResultFieldMissing"), new Object[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecProcessMeta)smi;
        this.data = (ExecProcessData)sdi;
        super.dispose(smi, sdi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.log.isBasic()) {
            this.logBasic(Messages.getString("ExecProcess.Log.StartingToRun"));
        }
        try {
            try {
                while (this.processRow(this.meta, this.data) && !this.isStopped()) {
                }
                Object var3_1 = null;
                this.dispose(this.meta, this.data);
            }
            catch (Exception e) {
                this.logError(Messages.getString("ExecProcess.Log.UnexpectedError") + " : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                Object var3_2 = null;
                this.dispose(this.meta, this.data);
                this.logSummary();
                this.markStop();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
            throw throwable;
        }
        this.logSummary();
        this.markStop();
    }
}

