/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.imageio;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.apache.tools.ant.types.optional.imageio.BasicShape;
import org.apache.tools.ant.types.optional.imageio.ColorMapper;
import org.apache.tools.ant.types.optional.imageio.DrawOperation;
import org.apache.tools.ant.types.optional.imageio.ImageOperation;
import org.apache.tools.ant.types.optional.imageio.TransformOperation;

public class Rectangle
extends BasicShape
implements DrawOperation {
    private int arcwidth = 0;
    private int archeight = 0;

    public void setArcwidth(int w) {
        this.arcwidth = w;
    }

    public void setArcheight(int h) {
        this.archeight = h;
    }

    @Override
    public BufferedImage executeDrawOperation() {
        this.log("\tCreating Rectangle w=" + this.width + " h=" + this.height + " arcw=" + this.arcwidth + " arch=" + this.archeight);
        BufferedImage bi = new BufferedImage(this.width, this.height, 7);
        Graphics2D graphics = bi.createGraphics();
        if (!"transparent".equalsIgnoreCase(this.stroke)) {
            BasicStroke bStroke = new BasicStroke(this.strokeWidth);
            graphics.setColor(ColorMapper.getColorByName(this.stroke));
            graphics.setStroke(bStroke);
            if (this.arcwidth == 0 && this.archeight == 0) {
                graphics.drawRect(0, 0, this.width, this.height);
            } else {
                graphics.drawRoundRect(0, 0, this.width, this.height, this.arcwidth, this.archeight);
            }
        }
        if (!"transparent".equalsIgnoreCase(this.fill)) {
            graphics.setColor(ColorMapper.getColorByName(this.fill));
            if (this.arcwidth == 0 && this.archeight == 0) {
                graphics.fillRect(this.strokeWidth, this.strokeWidth, this.width - this.strokeWidth * 2, this.height - this.strokeWidth * 2);
            } else {
                graphics.fillRoundRect(this.strokeWidth, this.strokeWidth, this.width - this.strokeWidth * 2, this.height - this.strokeWidth * 2, this.arcwidth, this.archeight);
            }
        }
        for (ImageOperation instr : this.instructions) {
            if (instr instanceof DrawOperation) {
                BufferedImage img = ((DrawOperation)((Object)instr)).executeDrawOperation();
                graphics.drawImage(img, null, 0, 0);
                continue;
            }
            if (!(instr instanceof TransformOperation)) continue;
            bi = ((TransformOperation)instr).executeTransformOperation(bi);
            graphics = bi.createGraphics();
        }
        return bi;
    }
}

