/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.DrawableSequence;
import jalview.ResidueColourScheme;
import jalview.ResidueProperties;
import java.awt.Color;

public class ScoreColourScheme
extends ResidueColourScheme {
    public double min;
    public double max;
    public double[] scores;

    public ScoreColourScheme(double[] dArray, double d, double d2) {
        this.scores = dArray;
        this.min = d;
        this.max = d2;
    }

    public void setColours(DrawableSequence drawableSequence, int n) {
        Color color = Color.white;
        String string = drawableSequence.getSequence().substring(n, n + 1);
        try {
            if (this.colourThreshold > 0 && this.cons != null) {
                if (this.aboveThreshold(drawableSequence, n, this.colourThreshold)) {
                    color = this.findColour(drawableSequence, string, n);
                }
            } else {
                color = !(string.equals("-") || string.equals(".") || string.equals(" ")) ? this.findColour(drawableSequence, string, n) : Color.white;
            }
        }
        catch (Exception exception) {
            color = Color.white;
        }
        drawableSequence.setResidueBoxColour(n, color);
    }

    public Color findColour(DrawableSequence drawableSequence, String string, int n) {
        float f = (float)(this.scores[(Integer)ResidueProperties.aaHash.get(string)] - (double)((float)this.min)) / (float)(this.max - this.min);
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return this.makeColour(f);
    }

    public Color makeColour(float f) {
        return new Color(f, 0.0f, 1.0f - f);
    }
}

