/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authentication;

import java.util.function.Function;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.network.HttpSenderListener;

class HttpSenderAuthHeaderListener
implements HttpSenderListener {
    public static final String ZAP_AUTH_HEADER_VALUE = "ZAP_AUTH_HEADER_VALUE";
    public static final String ZAP_AUTH_HEADER = "ZAP_AUTH_HEADER";
    public static final String ZAP_AUTH_HEADER_SITE = "ZAP_AUTH_HEADER_SITE";
    private final String authHeaderValue;
    private final String authHeader;
    private final String authHeaderSite;

    public HttpSenderAuthHeaderListener(Function<String, String> propertyProvider) {
        String authHeaderValueVar = propertyProvider.apply(ZAP_AUTH_HEADER_VALUE);
        if (authHeaderValueVar != null && authHeaderValueVar.isEmpty()) {
            authHeaderValueVar = null;
        }
        this.authHeaderValue = authHeaderValueVar;
        String authHeaderVar = propertyProvider.apply(ZAP_AUTH_HEADER);
        if (authHeaderVar == null || authHeaderVar.isEmpty()) {
            authHeaderVar = "Authorization";
        }
        this.authHeader = authHeaderVar;
        String authHeaderSiteVar = propertyProvider.apply(ZAP_AUTH_HEADER_SITE);
        if (authHeaderSiteVar != null && authHeaderSiteVar.isEmpty()) {
            authHeaderSiteVar = null;
        }
        this.authHeaderSite = authHeaderSiteVar;
    }

    @Override
    public int getListenerOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onHttpRequestSend(HttpMessage msg, int initiator, HttpSender sender) {
        if (this.authHeaderValue != null && (this.authHeaderSite == null || msg.getRequestHeader().getHostName().contains(this.authHeaderSite))) {
            msg.getRequestHeader().setHeader(this.authHeader, this.authHeaderValue);
        }
    }

    @Override
    public void onHttpResponseReceive(HttpMessage msg, int initiator, HttpSender sender) {
    }
}

