// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAffineUnsignedLongArray
 * @brief   affine implicit array of unsigned long.
 *
 * vtkAffineUnsignedLongArray is an affine implicit array of values of type unsigned long.
 * see vtkAffineArray, vtkAffineImplicitBackend
 *
 * This file is generated by vtkImplicitArrays.cmake
 */

#ifndef vtkAffineUnsignedLongArray_h
#define vtkAffineUnsignedLongArray_h

#include "vtkAffineArray.h" // Real Superclass
#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkAffineArray<unsigned long>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkAffineUnsignedLongArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkAffineUnsignedLongArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkAffineUnsignedLongArray* New();
  static vtkAffineUnsignedLongArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned long);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkAffineUnsignedLongArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkAffineUnsignedLongArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the parameters for the affine backend.
   * slope is the unit variation and intercept is the value at 0.
   * Value at index is:
   *   value = slope * index + intercept
   */
  void ConstructBackend(unsigned long slope, unsigned long intercept);

protected:
  vtkAffineUnsignedLongArray();
  ~vtkAffineUnsignedLongArray() override;

private:
  typedef vtkAffineArray<unsigned long> RealSuperclass;

  vtkAffineUnsignedLongArray(const vtkAffineUnsignedLongArray&) = delete;
  void operator=(const vtkAffineUnsignedLongArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkAffineUnsignedLongArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
