/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.classfile;

public class ClassLoaderTable {
    private static final boolean DEBUG = System.getProperty("org.graalvm.visualvm.lib.jfluid.classfile.ClassLoaderTable") != null;
    private int[] parentLoaderIds;

    public int getParentLoader(int loader) {
        if (DEBUG) {
            System.err.println("ClassLoaderTable.DEBUG: getParent loader: " + loader);
        }
        if (loader >= this.parentLoaderIds.length) {
            return -1;
        }
        return this.parentLoaderIds[loader];
    }

    public void addChildAndParent(int[] thisAndParentLoaderData) {
        int ofs = thisAndParentLoaderData[2];
        if (ofs == 0) {
            this.addChildAndParent(thisAndParentLoaderData[0], thisAndParentLoaderData[1]);
        } else {
            int loaderId = thisAndParentLoaderData[0];
            for (int i = 0; i < ofs; ++i) {
                this.addChildAndParent(loaderId, loaderId + 1);
                ++loaderId;
            }
            this.addChildAndParent(loaderId, thisAndParentLoaderData[1]);
        }
    }

    public void initTable(int[] inParentLoaderIds) {
        int i;
        if (DEBUG) {
            System.err.println("ClassLoaderTable.DEBUG: init patent loader ids: " + inParentLoaderIds.length);
            for (i = 0; i < inParentLoaderIds.length; ++i) {
                System.err.println("ClassLoaderTable.DEBUG: inParentLoaderIds[" + i + "]=" + inParentLoaderIds[i]);
            }
        }
        this.parentLoaderIds = inParentLoaderIds;
        for (i = 0; i < this.parentLoaderIds.length; ++i) {
            if (this.parentLoaderIds[i] != -1) continue;
            this.parentLoaderIds[i] = 0;
        }
    }

    private void addChildAndParent(int childLoader, int parentLoader) {
        int maxLoader;
        if (DEBUG) {
            System.err.println("ClassLoaderTable.DEBUG: add child and parent: child: " + childLoader + ", parent: " + parentLoader);
        }
        int n = maxLoader = childLoader > parentLoader ? childLoader : parentLoader;
        if (this.parentLoaderIds.length < maxLoader + 1) {
            int[] oldTable = this.parentLoaderIds;
            this.parentLoaderIds = new int[childLoader * 2 + 1];
            System.arraycopy(oldTable, 0, this.parentLoaderIds, 0, oldTable.length);
        }
        if (parentLoader == -1) {
            parentLoader = 0;
        }
        this.parentLoaderIds[childLoader] = parentLoader;
    }
}

