/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapdump.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.ApplicationFinder;
import org.graalvm.visualvm.heapdump.HeapDumpSupport;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class HeapDumpArgument
extends OptionProcessor {
    private static final String LONG_NAME = "heapdump";
    private static final Option ARGUMENT = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"heapdump"), (String)"org.graalvm.visualvm.heapdump.impl.Bundle", (String)"Argument_ShortDescr");

    protected Set<Option> getOptions() {
        return Collections.singleton(ARGUMENT);
    }

    protected void process(Env env, Map<Option, String[]> maps) throws CommandException {
        String[] pids = maps.get(ARGUMENT);
        if (pids != null && pids.length == 1) {
            try {
                int pid = Integer.valueOf(pids[0]);
                new ApplicationFinder(pid){

                    public void found(Application application) {
                        HeapDumpSupport.getInstance().takeHeapDump(application, true);
                    }

                    public void notFound(int pid, String id) {
                        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(HeapDumpArgument.class, (String)"MSG_NO_APP_PID", (Object[])new Object[]{Integer.toString(pid)}), 2);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)desc);
                    }
                }.find();
            }
            catch (NumberFormatException e) {
                throw new CommandException(0, "Incorrect pid format for --heapdump: " + e.getMessage());
            }
        } else {
            throw new CommandException(0, "--heapdump requires exactly one value");
        }
    }
}

