/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;

public abstract class HeapViewerNodeAction
extends AbstractAction {
    private final int position;

    public HeapViewerNodeAction(String name, int position) {
        this.putValue("Name", name);
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isMiddleButtonDefault(ActionEvent e) {
        return false;
    }

    public static final class Actions {
        private final List<HeapViewerNodeAction> actions;

        private Actions(List<HeapViewerNodeAction> actions) {
            this.actions = actions;
        }

        public static Actions forNode(HeapViewerNode node, Collection<Provider> actionProviders, HeapContext context, HeapViewerActions actions, HeapViewerNodeAction ... additionalActions) {
            HeapViewerNode loop = HeapViewerNode.getValue(node, DataType.LOOP, context.getFragment().getHeap());
            if (loop != null) {
                node = loop;
            }
            ArrayList<HeapViewerNodeAction> actionsList = new ArrayList<HeapViewerNodeAction>();
            for (Provider provider : actionProviders) {
                HeapViewerNodeAction[] providerActions = provider.getActions(node, context, actions);
                if (providerActions == null) continue;
                Collections.addAll(actionsList, providerActions);
            }
            if (additionalActions != null) {
                Collections.addAll(actionsList, additionalActions);
            }
            Collections.sort(actionsList, new Comparator<HeapViewerNodeAction>(){

                @Override
                public int compare(HeapViewerNodeAction a1, HeapViewerNodeAction a2) {
                    return Integer.compare(a1.getPosition(), a2.getPosition());
                }
            });
            return new Actions(actionsList);
        }

        public void performDefaultAction(ActionEvent e) {
            for (HeapViewerNodeAction action : this.actions) {
                if (!action.isDefault()) continue;
                if (action.isEnabled()) {
                    action.actionPerformed(e);
                }
                return;
            }
        }

        public void performMiddleButtonAction(ActionEvent e) {
            for (HeapViewerNodeAction action : this.actions) {
                if (!action.isMiddleButtonDefault(e) || !action.isEnabled()) continue;
                action.actionPerformed(e);
                return;
            }
        }

        public void populatePopup(JPopupMenu popup) {
            int lastPosition = -1;
            for (HeapViewerNodeAction action : this.actions) {
                int position = action.getPosition() / 100;
                if (position > lastPosition && lastPosition != -1) {
                    popup.addSeparator();
                }
                JMenuItem mi = new JMenuItem(action);
                if (action.isDefault()) {
                    mi.setFont(mi.getFont().deriveFont(1));
                }
                popup.add(mi);
                lastPosition = position;
            }
        }
    }

    public static abstract class Provider {
        public abstract boolean supportsView(HeapContext var1, String var2);

        public abstract HeapViewerNodeAction[] getActions(HeapViewerNode var1, HeapContext var2, HeapViewerActions var3);
    }
}

