/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.properties.PropertiesPanel;
import org.graalvm.visualvm.core.properties.PropertiesProvider;
import org.graalvm.visualvm.jmx.JmxConnectionCustomizer;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.graalvm.visualvm.jmx.impl.JmxConnectionSupportImpl;
import org.openide.util.NbBundle;

public final class JmxPropertiesProvider
extends PropertiesProvider<JmxApplication> {
    public static final int CATEGORY_JMX_CONNECTION = 200;
    private static final String PROP_CONN_CUSTOMIZER_ID = "prop_conn_customizer_id";

    public JmxPropertiesProvider() {
        super(NbBundle.getMessage(JmxPropertiesProvider.class, (String)"CAP_JmxConnection"), NbBundle.getMessage(JmxPropertiesProvider.class, (String)"DESCR_JmxConnection"), 200, 0);
    }

    public PropertiesPanel createPanel(JmxApplication application) {
        JmxConnectionCustomizer customizer = JmxPropertiesProvider.getCustomizer(application);
        return customizer == null ? null : customizer.createPanel((DataSource)application);
    }

    public boolean supportsDataSource(JmxApplication application) {
        if (application == null) {
            return false;
        }
        JmxConnectionCustomizer customizer = JmxPropertiesProvider.getCustomizer(application);
        return customizer == null ? false : customizer.supportsDataSource(application);
    }

    public void propertiesDefined(PropertiesPanel panel, JmxApplication application) {
        JmxConnectionCustomizer customizer = JmxPropertiesProvider.getCustomizer(application);
        if (customizer != null) {
            customizer.propertiesDefined(panel, application);
        }
    }

    public void propertiesChanged(PropertiesPanel panel, JmxApplication application) {
        JmxConnectionCustomizer customizer = JmxPropertiesProvider.getCustomizer(application);
        if (customizer != null) {
            customizer.propertiesChanged(panel, application);
        }
    }

    public void propertiesCancelled(PropertiesPanel panel, JmxApplication application) {
        JmxConnectionCustomizer customizer = JmxPropertiesProvider.getCustomizer(application);
        if (customizer != null) {
            customizer.propertiesCancelled(panel, application);
        }
    }

    static void setCustomizer(JmxApplication application, JmxConnectionCustomizer customizer) {
        JmxPropertiesProvider.setCustomizer(application.getStorage(), customizer);
    }

    private static void setCustomizer(Storage storage, JmxConnectionCustomizer customizer) {
        storage.setCustomProperty(PROP_CONN_CUSTOMIZER_ID, customizer.getId());
    }

    private static JmxConnectionCustomizer getCustomizer(JmxApplication application) {
        String customizerId = application.getStorage().getCustomProperty(PROP_CONN_CUSTOMIZER_ID);
        return customizerId != null ? JmxConnectionSupportImpl.getCustomizer(customizerId) : null;
    }
}

