/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;

public final class StringToolkit {
    private static final String UTF_8 = "UTF-8";

    private StringToolkit() {
        throw new AssertionError((Object)"This is not the constructor you are looking for!");
    }

    public static String readString(InputStream in) throws IOException {
        return StringToolkit.readString(in, UTF_8);
    }

    public static String readString(InputStream in, String charsetName) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            buf.write((byte)result);
            result = bis.read();
        }
        return buf.toString(charsetName);
    }

    public static String encodeFilename(String string) {
        try {
            return URLEncoder.encode(string, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return string.replaceAll("\\W+", "-");
        }
    }

    public static String join(Collection<?> s, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = s.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) break;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String join(Object[] a, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < a.length - 1; ++i) {
            builder.append(String.valueOf(a[i]));
            builder.append(delimiter);
        }
        builder.append(a[a.length - 1]);
        return builder.toString();
    }
}

