/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6;

import io.grpc.Status;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.grpc.v1_6.CapturedGrpcMetadataUtil;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRpcAttributesGetter;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.List;
import javax.annotation.Nullable;

final class GrpcAttributesExtractor
implements AttributesExtractor<GrpcRequest, Status> {
    private final GrpcRpcAttributesGetter getter;
    private final List<String> capturedRequestMetadata;

    GrpcAttributesExtractor(GrpcRpcAttributesGetter getter, List<String> requestMetadataValuesToCapture) {
        this.getter = getter;
        this.capturedRequestMetadata = CapturedGrpcMetadataUtil.lowercase(requestMetadataValuesToCapture);
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, GrpcRequest request) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, GrpcRequest request, @Nullable Status status, @Nullable Throwable error) {
        if (status != null) {
            attributes.put(SemanticAttributes.RPC_GRPC_STATUS_CODE, status.getCode().value());
        }
        for (String key : this.capturedRequestMetadata) {
            List<String> value = this.getter.metadataValue(request, key);
            if (value.isEmpty()) continue;
            attributes.put(CapturedGrpcMetadataUtil.requestAttributeKey(key), value);
        }
    }
}

