/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.internal.UserAgentUtils;
import software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest;
import software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse;
import software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumber;

public class ListSMSSandboxPhoneNumbersIterable
implements SdkIterable<ListSmsSandboxPhoneNumbersResponse> {
    private final SnsClient client;
    private final ListSmsSandboxPhoneNumbersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSMSSandboxPhoneNumbersIterable(SnsClient client, ListSmsSandboxPhoneNumbersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSmsSandboxPhoneNumbersResponseFetcher();
    }

    public Iterator<ListSmsSandboxPhoneNumbersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SMSSandboxPhoneNumber> phoneNumbers() {
        Function<ListSmsSandboxPhoneNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.phoneNumbers() != null) {
                return response.phoneNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSmsSandboxPhoneNumbersResponseFetcher
    implements SyncPageFetcher<ListSmsSandboxPhoneNumbersResponse> {
        private ListSmsSandboxPhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(ListSmsSandboxPhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSmsSandboxPhoneNumbersResponse nextPage(ListSmsSandboxPhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return ListSMSSandboxPhoneNumbersIterable.this.client.listSMSSandboxPhoneNumbers(ListSMSSandboxPhoneNumbersIterable.this.firstRequest);
            }
            return ListSMSSandboxPhoneNumbersIterable.this.client.listSMSSandboxPhoneNumbers((ListSmsSandboxPhoneNumbersRequest)((Object)ListSMSSandboxPhoneNumbersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

