/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.ParserVisitor;

public class ASTIdentifier
extends JexlNode {
    private static final long serialVersionUID = 1L;
    private static final int REDEFINED = 0;
    private static final int SHADED = 1;
    private static final int CAPTURED = 2;
    private static final int LEXICAL = 3;
    private static final int CONST = 4;
    protected String name;
    protected int symbol = -1;
    protected int flags;

    private static boolean isSet(int ordinal, int mask) {
        return (mask & 1 << ordinal) != 0;
    }

    private static int set(int ordinal, int mask, boolean value) {
        return value ? mask | 1 << ordinal : mask & ~(1 << ordinal);
    }

    ASTIdentifier(int id) {
        super(id);
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return null;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public boolean isCaptured() {
        return ASTIdentifier.isSet(2, this.flags);
    }

    @Override
    public boolean isConstant() {
        return ASTIdentifier.isSet(4, this.flags);
    }

    public boolean isLexical() {
        return ASTIdentifier.isSet(3, this.flags);
    }

    public boolean isRedefined() {
        return ASTIdentifier.isSet(0, this.flags);
    }

    public boolean isShaded() {
        return ASTIdentifier.isSet(1, this.flags);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void setCaptured(boolean f) {
        this.flags = ASTIdentifier.set(2, this.flags, f);
    }

    public void setConstant(boolean f) {
        this.flags = ASTIdentifier.set(4, this.flags, f);
    }

    public void setLexical(boolean f) {
        this.flags = ASTIdentifier.set(3, this.flags, f);
    }

    public void setRedefined(boolean f) {
        this.flags = ASTIdentifier.set(0, this.flags, f);
    }

    public void setShaded(boolean f) {
        this.flags = ASTIdentifier.set(1, this.flags, f);
    }

    void setSymbol(int r, String identifier) {
        this.symbol = r;
        this.name = identifier;
    }

    void setSymbol(String identifier) {
        if (identifier.charAt(0) == '#') {
            this.symbol = Integer.parseInt(identifier.substring(1));
        }
        this.name = identifier;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

