/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.EventData;
import org.traccar.forward.EventForwarder;
import org.traccar.forward.ResultHandler;

public class EventForwarderKafka
implements EventForwarder {
    private final Producer<String, String> producer;
    private final ObjectMapper objectMapper;
    private final String topic;

    public EventForwarderKafka(Config config, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", config.getString(Keys.EVENT_FORWARD_URL));
        properties.put("acks", "all");
        properties.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        properties.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new KafkaProducer(properties);
        this.topic = config.getString(Keys.EVENT_FORWARD_TOPIC);
    }

    @Override
    public void forward(EventData eventData, ResultHandler resultHandler) {
        try {
            String key = Long.toString(eventData.getDevice().getId());
            String value = this.objectMapper.writeValueAsString((Object)eventData);
            this.producer.send(new ProducerRecord(this.topic, (Object)key, (Object)value));
            resultHandler.onResult(true, null);
        }
        catch (JsonProcessingException e) {
            resultHandler.onResult(false, e);
        }
    }
}

