/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.traccar.api.ExtendedObjectResource;
import org.traccar.handler.ComputedAttributesHandler;
import org.traccar.model.Attribute;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="attributes/computed")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AttributeResource
extends ExtendedObjectResource<Attribute> {
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ComputedAttributesHandler.Late computedAttributesHandler;

    public AttributeResource() {
        super(Attribute.class, "description");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="test")
    public Response test(@QueryParam(value="deviceId") long deviceId, Attribute entity) throws Exception {
        this.permissionsService.checkAdmin(this.getUserId());
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        Position position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.LatestPositions(deviceId)));
        Object key = new Object();
        try {
            this.cacheManager.addDevice(position.getDeviceId(), key);
            Object result = this.computedAttributesHandler.computeAttribute(entity, position);
            if (result != null) {
                String string = switch (entity.getType()) {
                    case "number", "boolean" -> Response.ok((Object)result).build();
                    default -> Response.ok((Object)result.toString()).build();
                };
                return string;
            }
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.cacheManager.removeDevice(position.getDeviceId(), key);
        }
    }

    @Override
    @POST
    public Response add(Attribute entity) throws Exception {
        this.permissionsService.checkAdmin(this.getUserId());
        return super.add(entity);
    }

    @Override
    @Path(value="{id}")
    @PUT
    public Response update(Attribute entity) throws Exception {
        this.permissionsService.checkAdmin(this.getUserId());
        return super.update(entity);
    }

    @Override
    @Path(value="{id}")
    @DELETE
    public Response remove(@PathParam(value="id") long id) throws Exception {
        this.permissionsService.checkAdmin(this.getUserId());
        return super.remove(id);
    }
}

