/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.rls.SubchannelStateManager;
import io.grpc.util.ForwardingLoadBalancerHelper;
import javax.annotation.Nonnull;

final class ChildLoadBalancerHelper
extends ForwardingLoadBalancerHelper {
    private final String target;
    private final LoadBalancer.Helper rlsHelper;
    private final SubchannelStateManager subchannelStateManager;
    private final LoadBalancer.SubchannelPicker picker;

    private ChildLoadBalancerHelper(String target, LoadBalancer.Helper rlsHelper, SubchannelStateManager subchannelStateManager, LoadBalancer.SubchannelPicker picker) {
        this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
        this.rlsHelper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)rlsHelper, (Object)"rlsHelper");
        this.subchannelStateManager = (SubchannelStateManager)Preconditions.checkNotNull((Object)subchannelStateManager, (Object)"subchannelStateManager");
        this.picker = (LoadBalancer.SubchannelPicker)Preconditions.checkNotNull((Object)picker, (Object)"picker");
    }

    protected LoadBalancer.Helper delegate() {
        return this.rlsHelper;
    }

    public void updateBalancingState(@Nonnull ConnectivityState newState, @Nonnull LoadBalancer.SubchannelPicker unused) {
        this.subchannelStateManager.updateState(this.target, newState);
        super.updateBalancingState(this.subchannelStateManager.getAggregatedState(), this.picker);
    }

    static final class ChildLoadBalancerHelperProvider {
        private final LoadBalancer.Helper helper;
        private final SubchannelStateManager subchannelStateManager;
        private final LoadBalancer.SubchannelPicker picker;

        ChildLoadBalancerHelperProvider(LoadBalancer.Helper helper, SubchannelStateManager subchannelStateManager, LoadBalancer.SubchannelPicker picker) {
            this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
            this.subchannelStateManager = (SubchannelStateManager)Preconditions.checkNotNull((Object)subchannelStateManager, (Object)"subchannelStateManager");
            this.picker = (LoadBalancer.SubchannelPicker)Preconditions.checkNotNull((Object)picker, (Object)"picker");
        }

        void init() {
            this.helper.updateBalancingState(ConnectivityState.CONNECTING, this.picker);
        }

        ChildLoadBalancerHelper forTarget(String target) {
            return new ChildLoadBalancerHelper(target, this.helper, this.subchannelStateManager, this.picker);
        }
    }
}

