/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoder;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoderUtil;
import com.hivemq.client.internal.mqtt.codec.decoder.mqtt5.Mqtt5MessageDecoderUtil;
import com.hivemq.client.internal.mqtt.datatypes.MqttBinaryData;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertyImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.util.ByteBufferUtil;
import com.hivemq.client.internal.util.Utf8Util;
import com.hivemq.client.internal.util.collections.ImmutableIntList;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PayloadFormatIndicator;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt5PublishDecoder
implements MqttMessageDecoder {
    private static final int MIN_REMAINING_LENGTH = 3;

    @Inject
    Mqtt5PublishDecoder() {
    }

    @Override
    @NotNull
    public MqttStatefulPublish decode(int flags, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        int readPropertyLength;
        boolean retain;
        boolean dup = (flags & 8) != 0;
        MqttQos qos = MqttMessageDecoderUtil.decodePublishQos(flags, dup);
        boolean bl = retain = (flags & 1) != 0;
        if (in.readableBytes() < 3) {
            throw MqttMessageDecoderUtil.remainingLengthTooShort();
        }
        byte[] topicBinary = MqttBinaryData.decode(in);
        if (topicBinary == null) {
            throw MqttMessageDecoderUtil.malformedTopic();
        }
        MqttTopicImpl topic = null;
        if (topicBinary.length != 0 && (topic = MqttTopicImpl.of(topicBinary)) == null) {
            throw MqttMessageDecoderUtil.malformedTopic();
        }
        int packetIdentifier = MqttMessageDecoderUtil.decodePublishPacketIdentifier(qos, in);
        int propertyLength = Mqtt5MessageDecoderUtil.decodePropertyLength(in);
        long messageExpiryInterval = Long.MAX_VALUE;
        Mqtt5PayloadFormatIndicator payloadFormatIndicator = null;
        MqttUtf8StringImpl contentType = null;
        MqttTopicImpl responseTopic = null;
        ByteBuffer correlationData = null;
        ImmutableList.Builder<MqttUserPropertyImpl> userPropertiesBuilder = null;
        int topicAlias = 0;
        ImmutableIntList.Builder subscriptionIdentifiersBuilder = null;
        int propertiesStartIndex = in.readerIndex();
        block10: while ((readPropertyLength = in.readerIndex() - propertiesStartIndex) < propertyLength) {
            int propertyIdentifier = Mqtt5MessageDecoderUtil.decodePropertyIdentifier(in);
            switch (propertyIdentifier) {
                case 2: {
                    messageExpiryInterval = Mqtt5MessageDecoderUtil.unsignedIntOnlyOnce(messageExpiryInterval, Long.MAX_VALUE, "message expiry interval", in);
                    continue block10;
                }
                case 1: {
                    short payloadFormatIndicatorByte = Mqtt5MessageDecoderUtil.unsignedByteOnlyOnce(payloadFormatIndicator != null, "payload format indicator", in);
                    if ((payloadFormatIndicator = Mqtt5PayloadFormatIndicator.fromCode(payloadFormatIndicatorByte)) != null) continue block10;
                    throw new MqttDecoderException("wrong payload format indicator: " + payloadFormatIndicatorByte);
                }
                case 3: {
                    contentType = Mqtt5MessageDecoderUtil.decodeUTF8StringOnlyOnce(contentType, "content type", in);
                    continue block10;
                }
                case 8: {
                    if (responseTopic != null) {
                        throw Mqtt5MessageDecoderUtil.moreThanOnce("response topic");
                    }
                    responseTopic = MqttTopicImpl.decode(in);
                    if (responseTopic != null) continue block10;
                    throw new MqttDecoderException(Mqtt5DisconnectReasonCode.TOPIC_NAME_INVALID, "malformed response topic");
                }
                case 9: {
                    correlationData = Mqtt5MessageDecoderUtil.decodeBinaryDataOnlyOnce(correlationData, "correlation data", in, context.useDirectBufferCorrelationData());
                    continue block10;
                }
                case 38: {
                    userPropertiesBuilder = Mqtt5MessageDecoderUtil.decodeUserProperty(userPropertiesBuilder, in);
                    continue block10;
                }
                case 35: {
                    if ((topicAlias = Mqtt5MessageDecoderUtil.unsignedShortOnlyOnce(topicAlias, 0, "topic alias", in)) != 0) continue block10;
                    throw new MqttDecoderException(Mqtt5DisconnectReasonCode.TOPIC_ALIAS_INVALID, "topic alias must not be 0");
                }
                case 11: {
                    int subscriptionIdentifier;
                    if (subscriptionIdentifiersBuilder == null) {
                        subscriptionIdentifiersBuilder = ImmutableIntList.builder();
                    }
                    if ((subscriptionIdentifier = MqttVariableByteInteger.decode(in)) < 0) {
                        throw new MqttDecoderException("malformed subscription identifier");
                    }
                    if (subscriptionIdentifier == 0) {
                        throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "subscription identifier must not be 0");
                    }
                    subscriptionIdentifiersBuilder.add(subscriptionIdentifier);
                    continue block10;
                }
            }
            throw Mqtt5MessageDecoderUtil.wrongProperty(propertyIdentifier);
        }
        if (readPropertyLength != propertyLength) {
            throw Mqtt5MessageDecoderUtil.malformedPropertyLength();
        }
        if (topicAlias != 0) {
            MqttTopicImpl[] topicAliasMapping = context.getTopicAliasMapping();
            if (topicAliasMapping == null || topicAlias > topicAliasMapping.length) {
                throw new MqttDecoderException(Mqtt5DisconnectReasonCode.TOPIC_ALIAS_INVALID, "topic alias must not exceed topic alias maximum");
            }
            if (topic == null) {
                topic = topicAliasMapping[topicAlias - 1];
                if (topic == null) {
                    throw new MqttDecoderException(Mqtt5DisconnectReasonCode.TOPIC_ALIAS_INVALID, "topic alias has no mapping");
                }
            } else {
                topicAliasMapping[topicAlias - 1] = topic;
                topicAlias |= 0x10000;
            }
        } else if (topic == null) {
            throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "topic alias must be present if topic name is zero length");
        }
        int payloadLength = in.readableBytes();
        ByteBuffer payload = null;
        if (payloadLength > 0) {
            payload = ByteBufferUtil.allocate(payloadLength, context.useDirectBufferPayload());
            in.readBytes(payload);
            payload.position(0);
            if (payloadFormatIndicator == Mqtt5PayloadFormatIndicator.UTF_8 && context.validatePayloadFormat() && Utf8Util.isWellFormed(ByteBufferUtil.getBytes(payload)) != 0L) {
                throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PAYLOAD_FORMAT_INVALID, "payload is not valid UTF-8");
            }
        }
        MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.build(userPropertiesBuilder);
        MqttPublish publish = new MqttPublish(topic, payload, qos, retain, messageExpiryInterval, payloadFormatIndicator, contentType, responseTopic, correlationData, userProperties, null);
        ImmutableIntList subscriptionIdentifiers = subscriptionIdentifiersBuilder == null ? MqttStatefulPublish.DEFAULT_NO_SUBSCRIPTION_IDENTIFIERS : subscriptionIdentifiersBuilder.build();
        return publish.createStateful(packetIdentifier, dup, topicAlias, subscriptionIdentifiers);
    }
}

