/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonp;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.fasterxml.jackson.datatype.jsonp.JsonMergePatchDeserializer;
import com.fasterxml.jackson.datatype.jsonp.JsonPatchDeserializer;
import com.fasterxml.jackson.datatype.jsonp.JsonValueDeserializer;
import com.fasterxml.jackson.datatype.jsonp.JsonValueSerializer;
import com.fasterxml.jackson.datatype.jsonp.PackageVersion;
import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonMergePatch;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatch;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import java.util.Collections;

public class JSONPModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    protected final JsonBuilderFactory _builderFactory;

    public JSONPModule() {
        this(JsonProvider.provider());
    }

    public JSONPModule(JsonProvider jsonProvider) {
        super(PackageVersion.VERSION);
        this._builderFactory = jsonProvider.createBuilderFactory(Collections.emptyMap());
        final JsonValueDeserializer jsonValueDeser = new JsonValueDeserializer(JsonValue.class, this._builderFactory);
        final JsonPatchDeserializer jsonPatchDeser = new JsonPatchDeserializer(jsonValueDeser);
        final JsonMergePatchDeserializer jsonMergePatchDeser = new JsonMergePatchDeserializer(jsonValueDeser);
        this.addSerializer(JsonValue.class, (JsonSerializer)new JsonValueSerializer());
        this.addSerializer(JsonPatch.class, (JsonSerializer)new JsonPatchSerializer());
        this.addSerializer(JsonMergePatch.class, (JsonSerializer)new JsonMergePatchSerializer());
        this.setDeserializers(new SimpleDeserializers(){

            public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) {
                if (type.isTypeOrSubTypeOf(JsonValue.class)) {
                    if (type.hasRawClass(JsonValue.class)) {
                        return jsonValueDeser;
                    }
                    return new JsonValueDeserializer(type.getRawClass(), JSONPModule.this._builderFactory);
                }
                if (JsonPatch.class.isAssignableFrom(type.getRawClass())) {
                    return jsonPatchDeser;
                }
                if (JsonMergePatch.class.isAssignableFrom(type.getRawClass())) {
                    return jsonMergePatchDeser;
                }
                return null;
            }

            public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
                if (type.hasRawClass(JsonArray.class)) {
                    return new JsonValueDeserializer(type.getRawClass(), JSONPModule.this._builderFactory);
                }
                return null;
            }

            public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
                if (type.hasRawClass(JsonObject.class)) {
                    return new JsonValueDeserializer(type.getRawClass(), JSONPModule.this._builderFactory);
                }
                return null;
            }

            public boolean hasDeserializerFor(DeserializationConfig config, Class<?> valueType) {
                return JsonValue.class.isAssignableFrom(valueType) || JsonPatch.class.isAssignableFrom(valueType) || JsonMergePatch.class.isAssignableFrom(valueType);
            }
        });
    }

    static class JsonMergePatchSerializer
    extends StdDelegatingSerializer {
        private static final long serialVersionUID = 1L;

        public JsonMergePatchSerializer() {
            super((Converter)new MergePatchConverter());
        }

        protected JsonMergePatchSerializer(Converter<Object, ?> converter, JavaType delegateType, JsonSerializer<?> delegateSerialize) {
            super(converter, delegateType, delegateSerialize);
        }

        protected StdDelegatingSerializer withDelegate(Converter<Object, ?> converter, JavaType delegateType, JsonSerializer<?> delegateSerializer) {
            return new JsonMergePatchSerializer(converter, delegateType, delegateSerializer);
        }

        static class MergePatchConverter
        extends StdConverter<JsonMergePatch, JsonValue> {
            MergePatchConverter() {
            }

            public JsonValue convert(JsonMergePatch value) {
                return value.toJsonValue();
            }
        }
    }

    static class JsonPatchSerializer
    extends StdDelegatingSerializer {
        private static final long serialVersionUID = 1L;

        public JsonPatchSerializer() {
            super((Converter)new PatchConverter());
        }

        protected JsonPatchSerializer(Converter<Object, ?> converter, JavaType delegateType, JsonSerializer<?> delegateSerialize) {
            super(converter, delegateType, delegateSerialize);
        }

        protected StdDelegatingSerializer withDelegate(Converter<Object, ?> converter, JavaType delegateType, JsonSerializer<?> delegateSerializer) {
            return new JsonPatchSerializer(converter, delegateType, delegateSerializer);
        }

        static class PatchConverter
        extends StdConverter<JsonPatch, JsonArray> {
            PatchConverter() {
            }

            public JsonArray convert(JsonPatch value) {
                return value.toJsonArray();
            }
        }
    }
}

