//: version "2.1"

module ALU(F, B, N, C, A, Z);
//: interface  /sz:(180, 121) /bd:[ Ri0>B[7:0](21/121) Ri1>A[7:0](58/121) Ri2>F[3:0](105/121) Lo0<C[7:0](32/121) Lo1<Z(80/121) Lo2<N(106/121) ]
supply0 w32;    //: /sn:0 {0}(20,-931)(20,-972)(-15,-972)(-15,-959){1}
input [7:0] B;    //: /sn:0 {0}(-248,-1431)(-158,-1431){1}
//: {2}(-154,-1431)(2,-1431){3}
//: {4}(-156,-1433)(-156,-1689)(-127,-1689){5}
//: {6}(-156,-1429)(-156,-1355){7}
//: {8}(-154,-1353)(1,-1353){9}
//: {10}(-156,-1351)(-156,-1303){11}
//: {12}(-154,-1301)(2,-1301){13}
//: {14}(-156,-1299)(-156,-1043){15}
//: {16}(-154,-1041)(8,-1041){17}
//: {18}(-156,-1039)(-156,-729){19}
//: {20}(-154,-727)(1,-727){21}
//: {22}(-156,-725)(-156,-443){23}
//: {24}(-154,-441)(2,-441){25}
//: {26}(-156,-439)(-156,-234){27}
//: {28}(-154,-232)(-2,-232){29}
//: {30}(-156,-230)(-156,-89){31}
//: {32}(-154,-87)(-5,-87){33}
//: {34}(-156,-85)(-156,65){35}
//: {36}(-154,67)(-6,67){37}
//: {38}(-156,69)(-156,169){39}
//: {40}(-154,171)(-3,171){41}
//: {42}(-156,173)(-156,265){43}
//: {44}(-154,267)(-3,267){45}
//: {46}(-156,269)(-156,396)(0,396){47}
supply0 w15;    //: /sn:0 {0}(14,-1235)(14,-1273)(-14,-1273)(-14,-1264){1}
input [3:0] F;    //: /sn:0 /dp:1 {0}(308,359)(381,359){1}
supply0 w3;    //: /sn:0 {0}(16,-1471)(16,-1508)(-8,-1508)(-8,-1498){1}
input [7:0] A;    //: /sn:0 {0}(-246,-1463)(-139,-1463){1}
//: {2}(-135,-1463)(2,-1463){3}
//: {4}(-137,-1465)(-137,-1579)(-126,-1579){5}
//: {6}(-137,-1461)(-137,-1360){7}
//: {8}(-135,-1358)(1,-1358){9}
//: {10}(-137,-1356)(-137,-1308){11}
//: {12}(-135,-1306)(2,-1306){13}
//: {14}(-137,-1304)(-137,-1229){15}
//: {16}(-135,-1227)(0,-1227){17}
//: {18}(-137,-1225)(-137,-925){19}
//: {20}(-135,-923)(6,-923){21}
//: {22}(-137,-921)(-137,-606){23}
//: {24}(-135,-604)(2,-604){25}
//: {26}(-137,-602)(-137,-266){27}
//: {28}(-135,-264)(-2,-264){29}
//: {30}(-137,-262)(-137,-121){31}
//: {32}(-135,-119)(-5,-119){33}
//: {34}(-137,-117)(-137,33){35}
//: {36}(-135,35)(-6,35){37}
//: {38}(-137,37)(-137,164){39}
//: {40}(-135,166)(-3,166){41}
//: {42}(-137,168)(-137,220){43}
//: {44}(-135,222)(-3,222){45}
//: {46}(-137,224)(-137,364)(-61,364){47}
output Z;    //: /sn:0 /dp:1 {0}(20,-1577)(-22,-1577){1}
supply0 w34;    //: /sn:0 {0}(15,-767)(15,-811)(-17,-811)(-17,-796){1}
supply0 w43;    //: /sn:0 {0}(97,340)(97,328)(118,328)(118,372){1}
supply0 w20;    //: /sn:0 {0}(14,356)(14,317)(-12,317)(-12,326){1}
output [7:0] C;    //: /sn:0 /dp:1 {0}(634,210)(685,210){1}
supply0 w29;    //: /sn:0 {0}(22,-1081)(22,-1125)(-10,-1125)(-10,-1110){1}
output N;    //: /sn:0 {0}(-23,-1687)(22,-1687){1}
wire [7:0] w6;    //: /sn:0 /dp:1 {0}(512,276)(235,276)(235,-113)(24,-113){1}
wire [7:0] w45;    //: /sn:0 {0}(40,479)(78,479)(78,412)(104,412){1}
wire [7:0] w7;    //: /sn:0 /dp:1 {0}(512,283)(221,283)(221,61)(23,61){1}
wire w61;    //: /sn:0 {0}(-120,-1584)(-81,-1584)(-81,-1579)(-43,-1579){1}
wire w60;    //: /sn:0 {0}(-120,-1574)(-43,-1574){1}
wire w56;    //: /sn:0 /dp:1 {0}(-120,-1544)(-61,-1544)(-61,-1559)(-43,-1559){1}
wire w16;    //: /sn:0 {0}(14,-1187)(14,-1154)(-13,-1154)(-13,-1169){1}
wire [7:0] w14;    //: /sn:0 {0}(29,-1211)(331,-1211)(331,163)(512,163){1}
wire [7:0] w19;    //: /sn:0 {0}(29,380)(104,380){1}
wire [7:0] w4;    //: /sn:0 /dp:1 {0}(512,263)(259,263)(259,-441)(23,-441){1}
wire [2:0] w38;    //: /sn:0 /dp:1 {0}(13,-403)(13,-367)(-5,-367){1}
wire w69;    //: /sn:0 {0}(-121,-1704)(-76,-1704)(-76,-1694)(-44,-1694){1}
wire [2:0] w0;    //: /sn:0 {0}(387,364)(434,364)(434,235){1}
//: {2}(436,233)(528,233)(528,264){3}
//: {4}(434,231)(434,114)(528,114)(528,144){5}
wire w66;    //: /sn:0 {0}(-121,-1674)(-81,-1674)(-81,-1679)(-44,-1679){1}
wire w64;    //: /sn:0 {0}(-120,-1614)(-65,-1614)(-65,-1594)(-43,-1594){1}
wire [7:0] w37;    //: /sn:0 {0}(30,-743)(292,-743)(292,183)(512,183){1}
wire w63;    //: /sn:0 {0}(-120,-1604)(-70,-1604)(-70,-1589)(-43,-1589){1}
wire [7:0] w21;    //: /sn:0 /dp:1 {0}(512,190)(279,190)(279,-604)(23,-604){1}
wire w67;    //: /sn:0 {0}(-121,-1684)(-44,-1684){1}
wire w58;    //: /sn:0 {0}(-121,-1654)(-62,-1654)(-62,-1669)(-44,-1669){1}
wire [7:0] w31;    //: /sn:0 {0}(35,-907)(305,-907)(305,176)(512,176){1}
wire [7:0] w28;    //: /sn:0 {0}(37,-1057)(319,-1057)(319,170)(512,170){1}
wire [7:0] w41;    //: /sn:0 {0}(24,-93)(69,-93)(69,-79){1}
wire [7:0] w36;    //: /sn:0 {0}(-27,-759)(1,-759){1}
wire [7:0] w24;    //: /sn:0 /dp:1 {0}(22,-1355)(356,-1355)(356,150)(512,150){1}
wire [7:0] w23;    //: /sn:0 {0}(541,167)(595,167)(595,200)(605,200){1}
wire w1;    //: /sn:0 {0}(387,354)(421,354)(421,100)(621,100)(621,187){1}
wire [2:0] w25;    //: /sn:0 /dp:1 {0}(-7,-540)(13,-540)(13,-566){1}
wire w65;    //: /sn:0 {0}(-121,-1664)(-72,-1664)(-72,-1674)(-44,-1674){1}
wire [7:0] w40;    //: /sn:0 {0}(81,-253)(111,-253)(111,-290){1}
wire w35;    //: /sn:0 {0}(15,-719)(15,-686)(-18,-686)(-18,-702){1}
wire [7:0] w18;    //: /sn:0 {0}(-33,-891)(6,-891){1}
wire [7:0] w8;    //: /sn:0 /dp:1 {0}(512,290)(206,290)(206,169)(18,169){1}
wire w71;    //: /sn:0 {0}(-121,-1724)(-66,-1724)(-66,-1704)(-44,-1704){1}
wire w68;    //: /sn:0 {0}(-121,-1694)(-82,-1694)(-82,-1689)(-44,-1689){1}
wire w30;    //: /sn:0 {0}(22,-1033)(22,-1000)(-11,-1000)(-11,-1016){1}
wire [7:0] w17;    //: /sn:0 {0}(-43,-1195)(0,-1195){1}
wire [7:0] w22;    //: /sn:0 /dp:1 {0}(23,-1303)(344,-1303)(344,156)(512,156){1}
wire w59;    //: /sn:0 {0}(-120,-1564)(-80,-1564)(-80,-1569)(-43,-1569){1}
wire w62;    //: /sn:0 {0}(-120,-1594)(-75,-1594)(-75,-1584)(-43,-1584){1}
wire w57;    //: /sn:0 {0}(-120,-1554)(-71,-1554)(-71,-1564)(-43,-1564){1}
wire [7:0] w44;    //: /sn:0 {0}(-45,364)(0,364){1}
wire w2;    //: /sn:0 {0}(16,-1423)(16,-1392)(-10,-1392)(-10,-1406){1}
wire [7:0] w12;    //: /sn:0 {0}(31,-1447)(369,-1447)(369,143)(512,143){1}
wire [7:0] w11;    //: /sn:0 {0}(512,310)(177,310)(177,396)(133,396){1}
wire w70;    //: /sn:0 {0}(-121,-1714)(-71,-1714)(-71,-1699)(-44,-1699){1}
wire [7:0] w10;    //: /sn:0 {0}(512,303)(176,303)(176,267)(13,267){1}
wire [7:0] w27;    //: /sn:0 {0}(-41,-1073)(8,-1073){1}
wire [7:0] w13;    //: /sn:0 {0}(541,287)(595,287)(595,220)(605,220){1}
wire w48;    //: /sn:0 {0}(118,420)(118,445)(151,445)(151,429){1}
wire w33;    //: /sn:0 {0}(20,-883)(20,-848)(-20,-848)(-20,-863){1}
wire [7:0] w5;    //: /sn:0 {0}(512,270)(247,270)(247,-243)(81,-243){1}
wire w42;    //: /sn:0 {0}(14,404)(14,440)(-15,440)(-15,425){1}
wire [7:0] w9;    //: /sn:0 /dp:1 {0}(512,296)(190,296)(190,222)(13,222){1}
wire [7:0] w39;    //: /sn:0 {0}(23,41)(69,41)(69,21){1}
wire [15:0] w26;    //: /sn:0 {0}(27,-248)(75,-248){1}
//: enddecls

  //: joint g61 (A) @(-137, -264) /anc:1 /w:[ 28 27 -1 30 ]
  add g4 (.A(B), .B(A), .S(w12), .CI(w3), .CO(w2));   //: @(18,-1447) /sn:0 /R:1 /anc:1 /w:[ 3 3 0 0 0 ]
  mux g8 (.I0(w12), .I1(w24), .I2(w22), .I3(w14), .I4(w28), .I5(w31), .I6(w37), .I7(w21), .S(w0), .Z(w23));   //: @(528,167) /sn:0 /R:1 /anc:1 /w:[ 1 1 1 1 1 1 1 0 5 0 ]
  //: joint g86 (A) @(-137, 222) /anc:1 /w:[ 44 43 -1 46 ]
  //: joint g58 (A) @(-137, -604) /anc:1 /w:[ 24 23 -1 26 ]
  concat g55 (.I0(w5), .I1(w40), .Z(w26));   //: @(76,-248) /sn:0 /R:2 /anc:1 /w:[ 1 0 1 ] /dr:1
  lshift g51 (.I(B), .Z(w4), .S(w38));   //: @(13,-441) /sn:0 /R:1 /anc:1 /w:[ 25 1 0 ]
  //: comment g37 /dolink:0 /link:"" @(47,-924) /sn:0 /R:1 /anc:1
  //: /line:"DEC A"
  //: /end
  //: comment g34 /dolink:0 /link:"" @(39,-1227) /sn:0 /R:1 /anc:1
  //: /line:"INC A"
  //: /end
  add g13 (.A(w17), .B(A), .S(w14), .CI(w15), .CO(w16));   //: @(16,-1211) /sn:0 /R:1 /anc:1 /w:[ 1 17 0 0 0 ]
  concat g3 (.I0(w0), .I1(w1), .Z(F));   //: @(382,359) /sn:0 /R:2 /anc:1 /w:[ 0 0 1 ] /dr:1
  //: dip g89 (w45) @(2,479) /sn:0 /R:1 /anc:1 /w:[ 0 ] /st:1
  //: joint g77 (B) @(-156, 171) /anc:1 /w:[ 40 39 -1 42 ]
  //: joint g76 (A) @(-137, 166) /anc:1 /w:[ 40 39 -1 42 ]
  div g65 (.A(B), .B(A), .Q(w39), .R(w7));   //: @(10,51) /sn:0 /R:1 /anc:1 /w:[ 37 37 0 1 ]
  //: input g2 (F) @(306,359) /sn:0 /anc:1 /w:[ 0 ]
  //: joint g59 (B) @(-156, -441) /anc:1 /w:[ 24 23 -1 26 ]
  //: joint g72 (A) @(-137, 35) /anc:1 /w:[ 36 35 -1 38 ]
  //: input g1 (B) @(-250,-1431) /sn:0 /anc:1 /w:[ 0 ]
  //: output g98 (N) @(19,-1687) /sn:0 /anc:1 /w:[ 1 ]
  //: comment g64 /dolink:0 /link:"" @(33,-138) /sn:0 /R:2 /anc:1
  //: /line:"B div A - remainder lost"
  //: /end
  and g96 (.I0(!w71), .I1(!w70), .I2(!w69), .I3(!w68), .I4(!w67), .I5(!w66), .I6(!w65), .I7(!w58), .Z(N));   //: @(-33,-1687) /sn:0 /anc:1 /w:[ 1 1 1 1 1 1 1 1 0 ]
  led g16 (.I(w16));   //: @(-13,-1176) /sn:0 /anc:1 /w:[ 1 ] /type:0
  //: frame g11 @(394,73) /sn:0 /anc:1 /wi:271 /ht:251 /tx:""
  //: joint g87 (B) @(-156, 267) /anc:1 /w:[ 44 43 -1 46 ]
  //: comment g78 /dolink:0 /link:"" @(27,206) /sn:0 /anc:1
  //: /line:"Not A"
  //: /end
  //: comment g50 /dolink:0 /link:"" @(29,-625) /sn:0 /R:1 /anc:1
  //: /line:"Shift A left 1 bit"
  //: /end
  //: supply0 g28 (w29) @(-10,-1104) /sn:0 /anc:1 /w:[ 1 ]
  //: output g10 (C) @(682,210) /sn:0 /anc:1 /w:[ 1 ]
  //: comment g32 /dolink:0 /link:"" @(33,-1372) /sn:0 /R:1 /anc:1
  //: /line:"A and B"
  //: /end
  led g27 (.I(w30));   //: @(-11,-1023) /sn:0 /anc:1 /w:[ 1 ] /type:0
  //: joint g19 (A) @(-137, -1463) /anc:1 /w:[ 2 4 1 6 ]
  //: comment g69 /dolink:0 /link:"" @(29,65) /sn:0 /anc:1
  //: /line:"B mod A - quotient lost"
  //: /end
  led g38 (.I(w33));   //: @(-20,-870) /sn:0 /anc:1 /w:[ 1 ] /type:0
  mux g6 (.I0(w23), .I1(w13), .S(w1), .Z(C));   //: @(621,210) /sn:0 /R:1 /anc:1 /w:[ 1 1 1 0 ]
  //: comment g75 /dolink:0 /link:"" @(28,151) /sn:0 /anc:1
  //: /line:"A xor B"
  //: /end
  //: comment g57 /dolink:0 /link:"" @(29,-227) /sn:0 /anc:1
  //: /line:"A x B - overflow lost"
  //: /end
  //: comment g53 /dolink:0 /link:"" @(29,-461) /sn:0 /R:1 /anc:1
  //: /line:"Shift B left 1 bit"
  //: /end
  mux g7 (.I0(w4), .I1(w5), .I2(w6), .I3(w7), .I4(w8), .I5(w9), .I6(w10), .I7(w11), .S(w0), .Z(w13));   //: @(528,287) /sn:0 /R:1 /anc:1 /w:[ 0 0 0 0 0 0 0 0 3 0 ]
  //: joint g9 (w0) @(434, 233) /anc:1 /w:[ 2 4 -1 1 ]
  not g71 (.I(A), .Z(w9));   //: @(3,222) /sn:0 /anc:1 /w:[ 45 1 ]
  //: comment g31 /dolink:0 /link:"" @(42,-1467) /sn:0 /R:1 /anc:1
  //: /line:"A+B"
  //: /end
  or g20 (.I0(A), .I1(B), .Z(w22));   //: @(13,-1303) /sn:0 /anc:1 /w:[ 13 13 0 ]
  and g15 (.I0(A), .I1(B), .Z(w24));   //: @(12,-1355) /sn:0 /anc:1 /w:[ 9 9 0 ]
  //: joint g68 (B) @(-156, -87) /anc:1 /w:[ 32 31 -1 34 ]
  //: joint g67 (A) @(-137, -119) /anc:1 /w:[ 32 31 -1 34 ]
  //: supply0 g39 (w32) @(-15,-953) /sn:0 /anc:1 /w:[ 1 ]
  lshift g48 (.I(A), .Z(w21), .S(w25));   //: @(13,-604) /sn:0 /R:1 /anc:1 /w:[ 25 1 1 ]
  led g43 (.I(w35));   //: @(-18,-709) /sn:0 /anc:1 /w:[ 1 ] /type:0
  add g88 (.A(w45), .B(w19), .S(w11), .CI(w43), .CO(w48));   //: @(120,396) /sn:0 /R:1 /anc:1 /w:[ 1 1 1 1 0 ]
  //: joint g73 (B) @(-156, 67) /anc:1 /w:[ 36 35 -1 38 ]
  //: joint g62 (B) @(-156, -232) /anc:1 /w:[ 28 27 -1 30 ]
  //: dip g29 (w27) @(-79,-1073) /sn:0 /R:1 /anc:1 /w:[ 0 ] /st:1
  //: dip g25 (w38) @(-43,-367) /sn:0 /R:1 /anc:1 /w:[ 1 ] /st:1
  //: joint g17 (A) @(-137, -1306) /anc:1 /w:[ 12 11 -1 14 ]
  led g63 (.I(w41));   //: @(69,-72) /sn:0 /R:2 /anc:1 /w:[ 1 ] /type:2
  //: joint g52 (B) @(-156, -727) /anc:1 /w:[ 20 19 -1 22 ]
  //: supply0 g42 (w34) @(-17,-790) /sn:0 /anc:1 /w:[ 1 ]
  //: supply0 g83 (w20) @(-12,332) /sn:0 /anc:1 /w:[ 1 ]
  not g74 (.I(B), .Z(w10));   //: @(3,267) /sn:0 /anc:1 /w:[ 45 1 ]
  led g56 (.I(w40));   //: @(111,-297) /sn:0 /anc:1 /w:[ 1 ] /type:2
  //: supply0 g14 (w15) @(-14,-1258) /sn:0 /anc:1 /w:[ 1 ]
  //: supply0 g5 (w3) @(-8,-1492) /sn:0 /anc:1 /w:[ 1 ]
  concat g95 (.I0(w58), .I1(w65), .I2(w66), .I3(w67), .I4(w68), .I5(w69), .I6(w70), .I7(w71), .Z(B));   //: @(-126,-1689) /sn:0 /R:2 /anc:1 /w:[ 0 0 0 0 0 0 0 0 5 ] /dr:1
  concat g94 (.I0(w56), .I1(w57), .I2(w59), .I3(w60), .I4(w61), .I5(w62), .I6(w63), .I7(w64), .Z(A));   //: @(-125,-1579) /sn:0 /R:2 /anc:1 /w:[ 0 0 0 0 0 0 0 0 5 ] /dr:1
  //: comment g80 /dolink:0 /link:"" @(443,59) /sn:0 /anc:1
  //: /line:"16 x 1 Multiplexor"
  //: /end
  //: comment g79 /dolink:0 /link:"" @(27,252) /sn:0 /anc:1
  //: /line:"Not B"
  //: /end
  //: joint g47 (B) @(-156, -1041) /anc:1 /w:[ 16 15 -1 18 ]
  //: dip g44 (w36) @(-65,-759) /sn:0 /R:1 /anc:1 /w:[ 0 ] /st:255
  //: comment g92 /dolink:0 /link:"" @(-20,503) /sn:0 /anc:1
  //: /line:"B - A = B + Not A + 1"
  //: /end
  not g85 (.I(A), .Z(w44));   //: @(-55,364) /sn:0 /anc:1 /w:[ 47 0 ]
  led g84 (.I(w42));   //: @(-15,418) /sn:0 /anc:1 /w:[ 1 ] /type:0
  add g36 (.A(w18), .B(A), .S(w31), .CI(w32), .CO(w33));   //: @(22,-907) /sn:0 /R:1 /anc:1 /w:[ 1 21 0 0 0 ]
  //: dip g24 (w25) @(-45,-540) /sn:0 /R:1 /anc:1 /w:[ 0 ] /st:1
  //: joint g21 (A) @(-137, -1358) /anc:1 /w:[ 8 7 -1 10 ]
  //: joint g41 (A) @(-137, -1227) /anc:1 /w:[ 16 15 -1 18 ]
  //: dip g23 (w17) @(-81,-1195) /sn:0 /R:1 /anc:1 /w:[ 0 ] /st:1
  //: frame g93 @(-66,306) /sn:0 /anc:1 /wi:236 /ht:191 /tx:""
  add g81 (.A(B), .B(w44), .S(w19), .CI(w20), .CO(w42));   //: @(16,380) /sn:0 /R:1 /w:[ 47 1 0 0 0 ]
  div g60 (.A(B), .B(A), .Q(w6), .R(w41));   //: @(11,-103) /sn:0 /R:1 /anc:1 /w:[ 33 33 1 0 ]
  mult g54 (.A(B), .B(A), .P(w26));   //: @(14,-248) /sn:0 /R:1 /anc:1 /w:[ 29 29 0 ]
  //: dip g40 (w18) @(-71,-891) /sn:0 /R:1 /anc:1 /w:[ 0 ] /st:255
  led g90 (.I(w48));   //: @(151,422) /sn:0 /anc:1 /w:[ 1 ] /type:0
  xor g70 (.I0(A), .I1(B), .Z(w8));   //: @(8,169) /sn:0 /anc:1 /w:[ 41 41 1 ]
  //: comment g46 /dolink:0 /link:"" @(39,-759) /sn:0 /R:1
  //: /line:"DEC B"
  //: /end
  add g45 (.A(B), .B(w36), .S(w37), .CI(w34), .CO(w35));   //: @(17,-743) /sn:0 /R:1 /anc:1 /w:[ 21 1 0 0 0 ]
  //: comment g35 /dolink:0 /link:"" @(46,-1073) /sn:0 /R:1 /anc:1
  //: /line:"INC B"
  //: /end
  add g26 (.A(B), .B(w27), .S(w28), .CI(w29), .CO(w30));   //: @(24,-1057) /sn:0 /R:1 /anc:1 /w:[ 17 1 0 0 0 ]
  //: joint g22 (B) @(-156, -1353) /anc:1 /w:[ 8 7 -1 10 ]
  //: input g0 (A) @(-248,-1463) /sn:0 /anc:1 /w:[ 0 ]
  //: output g97 (Z) @(17,-1577) /sn:0 /anc:1 /w:[ 0 ]
  and g82 (.I0(!w64), .I1(!w63), .I2(!w62), .I3(!w61), .I4(!w60), .I5(!w59), .I6(!w57), .I7(!w56), .Z(Z));   //: @(-32,-1577) /sn:0 /anc:1 /w:[ 1 1 1 1 1 1 1 1 1 ]
  led g66 (.I(w39));   //: @(69,14) /sn:0 /anc:1 /w:[ 1 ] /type:2
  //: joint g18 (B) @(-156, -1431) /anc:1 /w:[ 2 4 1 6 ]
  led g12 (.I(w2));   //: @(-10,-1413) /sn:0 /anc:1 /w:[ 1 ] /type:0
  //: supply0 g91 (w43) @(97,346) /sn:0 /anc:1 /w:[ 0 ]
  //: comment g33 /dolink:0 /link:"" @(37,-1320) /sn:0 /R:1 /anc:1
  //: /line:"A or B"
  //: /end
  //: joint g30 (B) @(-156, -1301) /anc:1 /w:[ 12 11 -1 14 ]
  //: joint g49 (A) @(-137, -923) /anc:1 /w:[ 20 19 -1 22 ]

endmodule

module cpu(DI, MD, PA, DWE, DO, MA, clk, DA, PI, rst);
//: interface  /sz:(116, 360) /bd:[ Li0>rst(200/360) Li1>clk(166/360) Li2>PI[7:0](82/360) Ri0>MD[31:0](327/360) Ri1>DI[7:0](170/360) Lo0<POE(126/360) Lo1<PA[7:0](46/360) Ro0<DA[7:0](47/360) Ro1<MA[7:0](290/360) Ro2<DOE(214/360) Ro3<DO[7:0](130/360) Ro4<DWE(88/360) ]
input [31:0] MD;    //: /sn:0 /dp:1 {0}(2133,-35)(2133,-62)(2174,-62){1}
output [7:0] DO;    //: /sn:0 /dp:1 {0}(1339,937)(1339,117)(1137,117){1}
//: {2}(1133,117)(1109,117){3}
//: {4}(1105,117)(891,117){5}
//: {6}(889,115)(889,112){7}
//: {8}(889,119)(889,135)(940,135){9}
//: {10}(1107,119)(1107,936){11}
//: {12}(1135,119)(1135,128){13}
input [7:0] PI;    //: /sn:0 /dp:1 {0}(886,418)(886,395)(853,395){1}
output [7:0] MA;    //: /sn:0 /dp:1 {0}(2301,164)(2231,164){1}
input rst;    //: /sn:0 {0}(848,-61)(884,-61){1}
supply0 w36;    //: /sn:0 {0}(2052,284)(2052,274)(2076,274)(2076,303){1}
output [7:0] PA;    //: /sn:0 /dp:1 {0}(1755,375)(1790,375){1}
output DWE;    //: /sn:0 {0}(1587,-28)(1552,-28){1}
output [7:0] DA;    //: /sn:0 {0}(2202,265)(2254,265){1}
input [7:0] DI;    //: /sn:0 /dp:1 {0}(676,61)(769,61){1}
input clk;    //: /sn:0 {0}(426,133)(477,133)(477,105)(484,105){1}
wire w6;    //: /sn:0 {0}(1104,89)(1059,89)(1059,842)(922,842){1}
wire w32;    //: /sn:0 {0}(1104,69)(1037,69)(1037,568)(924,568){1}
wire [7:0] w7;    //: /sn:0 /dp:1 {0}(887,309)(887,285)(746,285){1}
//: {2}(744,283)(744,176){3}
//: {4}(746,174)(892,174)(892,208){5}
//: {6}(744,172)(744,41)(769,41){7}
//: {8}(744,287)(744,505){9}
//: {10}(746,507)(885,507)(885,553){11}
//: {12}(744,509)(744,639){13}
//: {14}(746,641)(884,641)(884,689){15}
//: {16}(744,643)(744,779){17}
//: {18}(746,781)(883,781)(883,827){19}
//: {20}(744,783)(744,1196)(840,1196){21}
wire w45;    //: /sn:0 {0}(570,101)(618,101){1}
//: {2}(622,101)(704,101)(704,101)(782,101){3}
//: {4}(786,101)(852,101){5}
//: {6}(784,103)(784,216){7}
//: {8}(786,218)(855,218){9}
//: {10}(784,220)(784,317){11}
//: {12}(786,319)(850,319){13}
//: {14}(784,321)(784,426){15}
//: {16}(786,428)(849,428){17}
//: {18}(784,430)(784,561){19}
//: {20}(786,563)(848,563){21}
//: {22}(784,565)(784,697){23}
//: {24}(786,699)(847,699){25}
//: {26}(784,701)(784,837)(846,837){27}
//: {28}(620,99)(620,-171)(2081,-171)(2081,-27){29}
//: {30}(2083,-25)(2096,-25){31}
//: {32}(2081,-23)(2081,7)(2192,7)(2192,-20)(2172,-20){33}
wire w46;    //: /sn:0 {0}(1862,-341)(1878,-341)(1878,-267)(1987,-267){1}
wire [7:0] w16;    //: /sn:0 {0}(1928,220)(1984,220)(1984,172)(2027,172){1}
wire [7:0] w14;    //: /sn:0 {0}(1782,54)(1110,54){1}
wire [7:0] w4;    //: /sn:0 {0}(1060,936)(1060,880)(993,880)(993,900){1}
wire [7:0] w15;    //: /sn:0 {0}(1299,937)(1299,863)(1138,863){1}
//: {2}(1136,861)(1136,851){3}
//: {4}(1134,863)(1069,863){5}
//: {6}(1065,863)(883,863)(883,848){7}
//: {8}(1067,865)(1067,936){9}
wire [3:0] w19;    //: /sn:0 /dp:1 {0}(1782,34)(1429,34)(1429,1269)(1022,1269){1}
wire w38;    //: /sn:0 {0}(1104,49)(1016,49)(1016,324)(926,324){1}
wire [7:0] w0;    //: /sn:0 /dp:1 {0}(1292,937)(1292,880)(1222,880)(1222,900){1}
wire w3;    //: /sn:0 {0}(432,100)(484,100){1}
wire w37;    //: /sn:0 /dp:1 {0}(2189,242)(2189,220)(2162,220)(2162,240)(1797,240)(1797,-14)(1772,-14)(1772,4)(1782,4){1}
wire [7:0] w34;    //: /sn:0 {0}(2056,154)(2202,154){1}
wire [7:0] w21;    //: /sn:0 {0}(2173,255)(1999,255){1}
//: {2}(1995,255)(1778,255){3}
//: {4}(1997,257)(1997,311)(2062,311){5}
wire w43;    //: /sn:0 {0}(505,103)(549,103){1}
wire w54;    //: /sn:0 {0}(1841,-344)(1831,-344)(1831,-410)(1989,-410)(1989,-365)(2389,-365)(2389,1373)(782,1373)(782,1244)(840,1244){1}
wire POE;    //: /sn:0 /dp:1 {0}(925,433)(1028,433)(1028,59)(1104,59){1}
wire [1:0] w31;    //: /sn:0 /dp:1 {0}(2043,131)(2043,-262)(1993,-262){1}
wire [7:0] w28;    //: /sn:0 {0}(1319,937)(1319,451){1}
//: {2}(1321,449)(1383,449)(1383,148)(2027,148){3}
//: {4}(1317,449)(1136,449){5}
//: {6}(1132,449)(1089,449){7}
//: {8}(1085,449)(886,449)(886,439){9}
//: {10}(1087,451)(1087,936){11}
//: {12}(1134,451)(1134,459){13}
wire [7:0] w20;    //: /sn:0 {0}(1305,937)(1305,715)(1136,715){1}
//: {2}(1132,715)(1075,715){3}
//: {4}(1071,715)(884,715)(884,710){5}
//: {6}(1073,717)(1073,936){7}
//: {8}(1134,717)(1134,725){9}
wire [7:0] w24;    //: /sn:0 {0}(1312,937)(1312,579)(1135,579){1}
//: {2}(1131,579)(1082,579){3}
//: {4}(1078,579)(885,579)(885,574){5}
//: {6}(1080,581)(1080,936){7}
//: {8}(1133,581)(1133,589){9}
wire [7:0] w41;    //: /sn:0 {0}(1707,385)(1726,385){1}
wire [7:0] w23;    //: /sn:0 {0}(1782,84)(1689,84)(1689,136)(2027,136){1}
wire [7:0] w1;    //: /sn:0 /dp:1 {0}(889,91)(889,51)(798,51){1}
wire DOE;    //: /sn:0 /dp:1 {0}(785,28)(785,19)(1104,19){1}
wire w25;    //: /sn:0 {0}(905,-63)(983,-63){1}
//: {2}(987,-63)(1039,-63)(1039,-157)(2218,-157)(2218,-32){3}
//: {4}(2216,-30)(2172,-30){5}
//: {6}(2218,-28)(2218,141){7}
//: {8}(985,-61)(985,94){9}
//: {10}(983,96)(928,96){11}
//: {12}(985,98)(985,211){13}
//: {14}(987,213)(1765,213)(1765,232){15}
//: {16}(983,213)(931,213){17}
//: {18}(985,215)(985,312){19}
//: {20}(987,314)(1742,314)(1742,352){21}
//: {22}(983,314)(926,314){23}
//: {24}(985,316)(985,421){25}
//: {26}(983,423)(925,423){27}
//: {28}(985,425)(985,556){29}
//: {30}(983,558)(924,558){31}
//: {32}(985,560)(985,692){33}
//: {34}(983,694)(923,694){35}
//: {36}(985,696)(985,832)(922,832){37}
wire w18;    //: /sn:0 {0}(851,-93)(875,-93)(875,-66)(884,-66){1}
wire [2:0] w8;    //: /sn:0 {0}(1782,74)(1626,74)(1626,1109)(1265,1109)(1265,953)(1293,953){1}
wire w40;    //: /sn:0 {0}(1104,29)(996,29)(996,106)(928,106){1}
wire w35;    //: /sn:0 {0}(2076,351)(2076,387)(2057,387)(2057,376){1}
wire [7:0] w30;    //: /sn:0 {0}(1726,365)(1704,365)(1704,335)(1327,335){1}
//: {2}(1323,335)(1136,335){3}
//: {4}(1132,335)(1095,335){5}
//: {6}(1091,335)(887,335)(887,330){7}
//: {8}(1093,337)(1093,936){9}
//: {10}(1134,337)(1134,346){11}
//: {12}(1325,337)(1325,937){13}
wire [1:0] w17;    //: /sn:0 /dp:1 {0}(1782,24)(1716,24)(1716,-20){1}
wire [7:0] w22;    //: /sn:0 {0}(2038,343)(2062,343){1}
wire [1:0] w53;    //: /sn:0 /dp:1 {0}(1791,-262)(1743,-262)(1743,14)(1782,14){1}
wire w49;    //: /sn:0 {0}(1950,-359)(1950,-325)(2360,-325)(2360,1341)(817,1341)(817,1270)(840,1270){1}
wire w57;    //: /sn:0 /dp:3 {0}(1782,44)(1445,44)(1445,-31)(1485,-31){1}
//: {2}(1489,-31)(1531,-31){3}
//: {4}(1487,-29)(1487,-3)(1499,-3){5}
wire [2:0] w12;    //: /sn:0 /dp:1 {0}(1782,64)(1611,64)(1611,1092)(1057,1092)(1057,952)(1061,952){1}
wire [7:0] w2;    //: /sn:0 {0}(2169,194)(2186,194)(2186,174)(2202,174){1}
wire w11;    //: /sn:0 {0}(424,31)(536,31)(536,98)(549,98){1}
wire [7:0] w10;    //: /sn:0 /dp:1 {0}(2027,160)(1969,160)(1969,180)(1929,180){1}
wire w13;    //: /sn:0 {0}(1104,79)(1048,79)(1048,704)(923,704){1}
wire [7:0] w27;    //: /sn:0 /dp:1 {0}(1749,265)(1706,265){1}
wire w52;    //: /sn:0 {0}(1797,-267)(1811,-267)(1811,-339)(1841,-339){1}
wire w48;    //: /sn:0 {0}(1515,-3)(1522,-3)(1522,-26)(1531,-26){1}
wire [7:0] w33;    //: /sn:0 {0}(1316,966)(1316,1222)(1022,1222){1}
wire [31:0] w5;    //: /sn:0 /dp:1 {0}(2133,-14)(2133,44)(1788,44){1}
wire [7:0] w29;    //: /sn:0 {0}(2091,327)(2140,327)(2140,275)(2173,275){1}
wire w9;    //: /sn:0 /dp:1 {0}(1987,-257)(1797,-257){1}
wire [7:0] w42;    //: /sn:0 {0}(892,229)(892,234)(1098,234){1}
//: {2}(1102,234)(1132,234){3}
//: {4}(1136,234)(1330,234){5}
//: {6}(1334,234)(1722,234)(1722,245)(1749,245){7}
//: {8}(1332,236)(1332,937){9}
//: {10}(1134,236)(1134,247){11}
//: {12}(1100,236)(1100,936){13}
wire [7:0] w26;    //: /sn:0 /dp:1 {0}(1084,965)(1084,1185)(1022,1185){1}
wire w39;    //: /sn:0 {0}(1104,39)(1006,39)(1006,223)(931,223){1}
//: enddecls

  and g8 (.I0(w57), .I1(w48), .Z(DWE));   //: @(1542,-28) /sn:0 /anc:1 /w:[ 3 1 1 ]
  //: dip g61 (w0) @(1222,911) /sn:0 /R:2 /anc:1 /w:[ 1 ] /st:0
  //: joint g4 (w45) @(784, 101) /anc:1 /w:[ 4 -1 3 6 ]
  //: joint g37 (w45) @(784, 699) /anc:1 /w:[ 24 23 -1 26 ]
  //: comment g34 /dolink:0 /link:"" @(878,555) /sn:0 /anc:1
  //: /line:"SP"
  //: /end
  register g13 (.Q(w24), .D(w7), .EN(!w32), .CLR(!w25), .CK(w45));   //: @(885,563) /sn:0 /anc:1 /w:[ 5 11 1 31 21 ]
  mux g3 (.I0(w7), .I1(DI), .S(DOE), .Z(w1));   //: @(785,51) /sn:0 /R:1 /anc:1 /w:[ 7 1 0 1 ]
  //: joint g51 (w20) @(1073, 715) /anc:1 /w:[ 3 -1 4 6 ]
  //: joint g55 (w42) @(1100, 234) /anc:1 /w:[ 2 -1 1 12 ]
  //: dip g58 (w4) @(993,911) /sn:0 /R:2 /anc:1 /w:[ 1 ] /st:0
  //: joint g86 (w21) @(1997, 255) /anc:1 /w:[ 1 -1 2 4 ]
  led g89 (.I(w42));   //: @(1134,254) /sn:0 /R:2 /anc:1 /w:[ 11 ] /type:2
  and g112 (.I0(w11), .I1(w43), .Z(w45));   //: @(560,101) /sn:0 /anc:1 /w:[ 1 1 0 ]
  //: input g2 (DI) @(674,61) /sn:0 /anc:1 /w:[ 0 ]
  //: joint g65 (w7) @(744, 781) /anc:1 /w:[ 18 17 -1 20 ]
  //: comment g76 /dolink:0 /link:"" @(1763,-239) /sn:0 /anc:1
  //: /line:"Two bits to branch."
  //: /line:"00 = No Branching"
  //: /line:"01 = Branch to MBR addr"
  //: /line:"10 = Branch to ADDR_1 if Z=0"
  //: /line:"11 = Branch to ADDR_2 if N=0"
  //: /end
  //: comment g77 /dolink:0 /link:"" @(1803,173) /sn:0 /anc:1
  //: /line:"ADDR_1"
  //: /end
  mux g110 (.I0(w21), .I1(w29), .S(w37), .Z(DA));   //: @(2189,265) /sn:0 /R:1 /anc:1 /w:[ 0 1 0 0 ]
  clock g111 (.Z(w11));   //: @(411,31) /sn:0 /anc:1 /w:[ 0 ] /omega:1000 /phi:0 /duty:50
  //: input g59 (MD) @(2176,-62) /sn:0 /R:2 /anc:1 /w:[ 1 ]
  //: joint g72 (w28) @(1319, 449) /anc:1 /w:[ 2 -1 4 1 ]
  //: dip g1 (w27) @(1668,265) /sn:0 /R:1 /anc:1 /w:[ 1 ] /st:0
  led g99 (.I(w15));   //: @(1136,844) /sn:0 /anc:1 /w:[ 3 ] /type:2
  //: joint g98 (w20) @(1134, 715) /anc:1 /w:[ 1 -1 2 8 ]
  concat g64 (.I0(w6), .I1(w13), .I2(w32), .I3(POE), .I4(w38), .I5(w39), .I6(w40), .I7(DOE), .Z(w14));   //: @(1109,54) /sn:0 /anc:1 /w:[ 0 0 0 1 0 0 0 1 1 ] /dr:0
  //: joint g96 (w24) @(1133, 579) /anc:1 /w:[ 1 -1 2 8 ]
  //: output g11 (PA) @(1787,375) /sn:0 /anc:1 /w:[ 1 ]
  register g16 (.Q(w42), .D(w7), .EN(!w39), .CLR(!w25), .CK(w45));   //: @(892,218) /sn:0 /anc:1 /w:[ 0 5 1 17 9 ]
  concat g122 (.I0(w9), .I1(w52), .Z(w53));   //: @(1792,-262) /sn:0 /R:2 /anc:1 /w:[ 1 0 0 ] /dr:1
  concat g121 (.I0(w9), .I1(w46), .Z(w31));   //: @(1992,-262) /sn:0 /anc:1 /w:[ 0 1 1 ] /dr:0
  mux g103 (.I0(w34), .I1(w2), .S(w25), .Z(MA));   //: @(2218,164) /sn:0 /R:1 /anc:1 /w:[ 1 1 7 1 ]
  register g28 (.Q(w28), .D(PI), .EN(!POE), .CLR(!w25), .CK(w45));   //: @(886,428) /sn:0 /w:[ 9 0 0 27 17 ]
  //: joint g50 (w15) @(1067, 863) /anc:1 /w:[ 5 -1 6 8 ]
  //: comment g78 /dolink:0 /link:"" @(1800,211) /sn:0 /anc:1
  //: /line:"ADDR_2"
  //: /end
  //: joint g10 (w30) @(1325, 335) /anc:1 /w:[ 1 -1 2 12 ]
  //: dip g87 (w22) @(2000,343) /sn:0 /R:1 /anc:1 /w:[ 0 ] /st:16
  buf g113 (.I(w57), .Z(w48));   //: @(1505,-3) /sn:0 /anc:1 /delay:" 500" /w:[ 5 0 ]
  register g32 (.Q(w20), .D(w7), .EN(!w13), .CLR(!w25), .CK(w45));   //: @(884,699) /sn:0 /anc:1 /w:[ 5 15 1 35 25 ]
  //: comment g27 /dolink:0 /link:"" @(880,312) /sn:0 /anc:1
  //: /line:"PC"
  //: /end
  //: joint g19 (w25) @(2218, -30) /anc:1 /w:[ -1 3 4 6 ]
  //: switch g102 (w18) @(834,-93) /sn:0 /anc:1 /w:[ 0 ] /st:0
  //: output g115 (DWE) @(1584,-28) /sn:0 /anc:1 /w:[ 0 ]
  //: comment g38 /dolink:0 /link:"" @(870,692) /sn:0 /anc:1
  //: /line:"TOS"
  //: /end
  //: joint g6 (DO) @(889, 117) /anc:1 /w:[ 5 6 -1 8 ]
  //: comment g69 /dolink:0 /link:"" @(1500,506) /sn:0 /anc:1
  //: /line:"or to the B BUS"
  //: /end
  //: comment g119 /dolink:0 /link:"" @(2000,-380) /sn:0 /anc:1
  //: /line:"Z=0"
  //: /line:""
  //: /end
  //: dip g75 (w16) @(1890,220) /sn:0 /R:1 /anc:1 /w:[ 0 ] /st:0
  //: output g7 (DO) @(937,135) /sn:0 /anc:1 /w:[ 9 ]
  //: joint g53 (w28) @(1087, 449) /anc:1 /w:[ 7 -1 8 10 ]
  //: output g57 (MA) @(2298,164) /sn:0 /anc:1 /w:[ 0 ]
  or g9 (.I0(w3), .I1(clk), .Z(w43));   //: @(495,103) /sn:0 /anc:1 /w:[ 1 1 0 ]
  mux g71 (.I0(w23), .I1(w28), .I2(w10), .I3(w16), .S(w31), .Z(w34));   //: @(2043,154) /sn:0 /R:1 /anc:1 /w:[ 1 3 0 1 0 0 ]
  //: joint g31 (w25) @(985, 314) /anc:1 /w:[ 20 19 22 24 ]
  register g20 (.Q(DO), .D(w1), .EN(!w40), .CLR(!w25), .CK(w45));   //: @(889,101) /sn:0 /anc:1 /w:[ 7 0 1 11 5 ]
  register g15 (.Q(w5), .D(MD), .EN(!w45), .CLR(!w25), .CK(w45));   //: @(2133,-25) /sn:0 /anc:1 /w:[ 0 0 33 5 31 ]
  //: comment g39 /dolink:0 /link:"" @(879,830) /sn:0 /anc:1
  //: /line:"H"
  //: /end
  //: comment g67 /dolink:0 /link:"" @(1633,504) /sn:0 /anc:1
  //: /line:"Which Register writes"
  //: /line:"to the A Bus:"
  //: /line:""
  //: /line:"001 = H"
  //: /line:"010 = TOS"
  //: /line:"011 = SP"
  //: /line:"100 = MBR"
  //: /line:"101 = PC"
  //: /line:"110 = MAR"
  //: /line:"111 = MBR"
  //: /end
  //: comment g68 /dolink:0 /link:"" @(1141,-123) /sn:0 /anc:1
  //: /line:"Which registers read from"
  //: /line:"the C Bus.  If the bit is"
  //: /line:"set, the following register"
  //: /line:"read:"
  //: /line:""
  //: /line:"0 = H"
  //: /line:"1 = TOS"
  //: /line:"2 = SP"
  //: /line:"3 = MBR from Text ROM"
  //: /line:"4 = PC"
  //: /line:"5 = MAR"
  //: /line:"6 = MDR"
  //: /line:"7 = 0 - MDR reads from C BUS"
  //: /line:"7 = 1 - MDR reads from DATA RAM"
  //: /end
  //: joint g43 (w7) @(744, 285) /anc:1 /w:[ 1 2 -1 8 ]
  mux g48 (.I0(w4), .I1(w15), .I2(w20), .I3(w24), .I4(w28), .I5(w30), .I6(w42), .I7(DO), .S(w12), .Z(w26));   //: @(1084,952) /sn:0 /anc:1 /w:[ 0 9 7 7 11 9 13 11 1 0 ]
  //: joint g88 (DO) @(1135, 117) /anc:1 /w:[ 1 -1 2 12 ]
  //: comment g29 /dolink:0 /link:"" @(877,421) /sn:0 /anc:1
  //: /line:"MBR"
  //: /end
  //: comment g25 /dolink:0 /link:"" @(879,94) /sn:0 /anc:1
  //: /line:"MDR"
  //: /end
  //: input g17 (clk) @(424,133) /sn:0 /anc:1 /w:[ 0 ]
  //: comment g62 /dolink:0 /link:"" @(1344,947) /sn:0 /anc:1
  //: /line:"A BUS"
  //: /end
  //: dip g73 (w10) @(1891,180) /sn:0 /R:1 /anc:1 /w:[ 1 ] /st:31
  //: dip g104 (w2) @(2131,194) /sn:0 /R:1 /anc:1 /w:[ 0 ] /st:0
  //: joint g42 (w25) @(985, 694) /anc:1 /w:[ -1 33 34 36 ]
  //: joint g52 (w24) @(1080, 579) /anc:1 /w:[ 3 -1 4 6 ]
  //: comment g63 /dolink:0 /link:"" @(1117,945) /sn:0 /anc:1
  //: /line:"B BUS"
  //: /end
  mux g106 (.I0(w42), .I1(w27), .S(w25), .Z(w21));   //: @(1765,255) /sn:0 /R:1 /anc:1 /w:[ 7 0 15 3 ]
  mux g107 (.I0(w30), .I1(w41), .S(w25), .Z(PA));   //: @(1742,375) /sn:0 /R:1 /anc:1 /w:[ 0 1 21 0 ]
  add g83 (.A(w22), .B(w21), .S(w29), .CI(w36), .CO(w35));   //: @(2078,327) /sn:0 /R:1 /anc:1 /w:[ 1 5 0 1 0 ]
  //: joint g100 (w15) @(1136, 863) /anc:1 /w:[ 1 2 4 -1 ]
  led g74 (.I(w17));   //: @(1716,-27) /sn:0 /anc:1 /w:[ 1 ] /type:2
  //: output g109 (DA) @(2251,265) /sn:0 /anc:1 /w:[ 1 ]
  //: joint g56 (DO) @(1107, 117) /anc:1 /w:[ 3 -1 4 10 ]
  ALU g14 (.F(w19), .A(w33), .B(w26), .N(w49), .Z(w54), .C(w7));   //: @(841, 1164) /sz:(180, 121) /sn:0 /anc:1 /p:[ Ri0>1 Ri1>1 Ri2>1 Lo0<1 Lo1<1 Lo2<21 ]
  //: switch g5 (w3) @(415,100) /sn:0 /anc:1 /w:[ 0 ] /st:1
  led g117 (.I(w49));   //: @(1950,-366) /sn:0 /anc:1 /w:[ 0 ] /type:0
  led g95 (.I(w24));   //: @(1133,596) /sn:0 /R:2 /anc:1 /w:[ 9 ] /type:2
  //: joint g94 (w28) @(1134, 449) /anc:1 /w:[ 5 -1 6 12 ]
  //: joint g44 (w7) @(744, 507) /anc:1 /w:[ 10 9 -1 12 ]
  //: comment g47 /dolink:0 /link:"" @(702,165) /sn:0 /R:1
  //: /line:"C Bus"
  //: /end
  //: comment g80 /dolink:0 /link:"" @(1701,151) /sn:0 /anc:1
  //: /line:"MBR addr"
  //: /end
  //: joint g79 (w45) @(2081, -25) /anc:1 /w:[ 30 29 -1 32 ]
  //: joint g21 (w25) @(985, 96) /anc:1 /w:[ -1 9 10 12 ]
  //: joint g92 (w30) @(1134, 335) /anc:1 /w:[ 3 -1 4 10 ]
  //: joint g36 (w45) @(784, 563) /anc:1 /w:[ 20 19 -1 22 ]
  //: joint g24 (w25) @(985, 213) /anc:1 /w:[ 14 13 16 18 ]
  //: joint g105 (w25) @(985, -63) /anc:1 /w:[ 2 -1 1 8 ]
  //: supply0 g84 (w36) @(2052,290) /sn:0 /anc:1 /w:[ 0 ]
  led g85 (.I(w35));   //: @(2057,369) /sn:0 /anc:1 /w:[ 1 ] /type:0
  //: joint g23 (w45) @(784, 218) /anc:1 /w:[ 8 7 -1 10 ]
  //: joint g41 (w25) @(985, 558) /anc:1 /w:[ -1 29 30 32 ]
  //: comment g116 /dolink:0 /link:"" @(1445,-74) /sn:0 /anc:1
  //: /line:"Delay to allow the"
  //: /line:"rest of the circuit"
  //: /line:"to catch up."
  //: /end
  or g101 (.I0(w18), .I1(rst), .Z(w25));   //: @(895,-63) /sn:0 /anc:1 /w:[ 1 1 0 ]
  led g93 (.I(w28));   //: @(1134,466) /sn:0 /R:2 /anc:1 /w:[ 13 ] /type:2
  //: comment g81 /dolink:0 /link:"" @(840,966) /sn:0 /anc:1
  //: /line:"0000 = A + B"
  //: /line:"0001 = A and B"
  //: /line:"0010 = A or B"
  //: /line:"0011 = INC A"
  //: /line:"0100 = INC B"
  //: /line:"0101 = DEC A"
  //: /line:"0110 = DEC B"
  //: /line:"0111 = Left shift A"
  //: /line:"1000 = Left shift B"
  //: /line:"1001 = A x B"
  //: /line:"1010 = B div A"
  //: /line:"1011 = B mod A"
  //: /line:"1100 = A xor B"
  //: /line:"1101 = NOT A"
  //: /line:"1110 = NOT B"
  //: /line:"1111 = B - A"
  //: /line:""
  //: /end
  concat g60 (.I0(w23), .I1(w8), .I2(w12), .I3(w14), .I4(w57), .I5(w19), .I6(w17), .I7(w53), .I8(w37), .Z(w5));   //: @(1787,44) /sn:0 /anc:1 /w:[ 0 0 0 0 0 0 0 1 1 1 ] /dr:0
  //: joint g40 (w25) @(985, 423) /anc:1 /w:[ -1 25 26 28 ]
  //: joint g54 (w30) @(1093, 335) /anc:1 /w:[ 5 -1 6 8 ]
  //: joint g90 (w42) @(1134, 234) /anc:1 /w:[ 4 -1 3 10 ]
  //: joint g35 (w45) @(784, 428) /anc:1 /w:[ 16 15 -1 18 ]
  //: comment g26 /dolink:0 /link:"" @(882,210) /sn:0 /anc:1
  //: /line:"MAR"
  //: /end
  register g22 (.Q(w30), .D(w7), .EN(!w38), .CLR(!w25), .CK(w45));   //: @(887,319) /sn:0 /anc:1 /w:[ 7 0 1 23 13 ]
  //: joint g45 (w7) @(744, 641) /anc:1 /w:[ 14 13 -1 16 ]
  //: joint g46 (w7) @(744, 174) /anc:1 /w:[ 4 6 -1 3 ]
  //: joint g70 (w45) @(620, 101) /w:[ 2 28 1 -1 ]
  //: joint g0 (w42) @(1332, 234) /w:[ 6 -1 5 8 ]
  //: comment g120 /dolink:0 /link:"" @(1958,-337) /sn:0 /anc:1
  //: /line:"N=0"
  //: /end
  //: joint g114 (w57) @(1487, -31) /anc:1 /w:[ 2 -1 1 4 ]
  led g97 (.I(w20));   //: @(1134,732) /sn:0 /R:2 /anc:1 /w:[ 9 ] /type:2
  led g82 (.I(DO));   //: @(1135,135) /sn:0 /R:2 /anc:1 /w:[ 13 ] /type:2
  //: comment g66 /dolink:0 /link:"" @(1700,120) /sn:0 /anc:1
  //: /line:"NEXT_ADDR"
  //: /end
  //: input g12 (PI) @(851,395) /sn:0 /anc:1 /w:[ 1 ]
  //: input g18 (rst) @(846,-61) /sn:0 /anc:1 /w:[ 0 ]
  led g91 (.I(w30));   //: @(1134,353) /sn:0 /R:2 /anc:1 /w:[ 11 ] /type:2
  register g33 (.Q(w15), .D(w7), .EN(!w6), .CLR(!w25), .CK(w45));   //: @(883,837) /sn:0 /anc:1 /w:[ 7 19 1 37 27 ]
  //: joint g30 (w45) @(784, 319) /anc:1 /w:[ 12 11 -1 14 ]
  //: dip g108 (w41) @(1669,385) /sn:0 /R:1 /anc:1 /w:[ 0 ] /st:0
  and g118 (.I0(w54), .I1(w52), .Z(w46));   //: @(1852,-341) /sn:0 /w:[ 0 1 0 ]
  mux g49 (.I0(w0), .I1(w15), .I2(w20), .I3(w24), .I4(w28), .I5(w30), .I6(w42), .I7(DO), .S(w8), .Z(w33));   //: @(1316,953) /sn:0 /anc:1 /w:[ 0 0 0 0 0 13 9 0 1 0 ]

endmodule

module main;    //: root_module
supply0 w14;    //: /sn:0 {0}(366,391)(366,408){1}
supply0 w11;    //: /sn:0 /dp:1 {0}(444,211)(444,197){1}
supply0 w13;    //: /sn:0 /dp:1 {0}(-14,183)(-14,199){1}
wire [7:0] w6;    //: /sn:0 {0}(178,364)(308,364){1}
//: {2}(312,364)(348,364){3}
//: {4}(310,366)(310,375){5}
wire [7:0] w7;    //: /sn:0 /dp:5 {0}(60,120)(-32,120){1}
//: {2}(-34,118)(-34,96){3}
//: {4}(-36,120)(-66,120)(-66,156)(-32,156){5}
wire w4;    //: /sn:0 {0}(458,197)(458,207){1}
//: {2}(460,209)(478,209)(478,137)(453,137){3}
//: {4}(451,135)(451,123){5}
//: {6}(451,139)(451,147){7}
//: {8}(458,211)(458,236)(424,236)(424,196)(389,196){9}
//: {10}(385,196)(280,196)(280,162)(178,162){11}
//: {12}(387,198)(387,275){13}
wire [7:0] w0;    //: /sn:0 /dp:5 {0}(178,121)(325,121){1}
//: {2}(327,119)(327,78){3}
//: {4}(327,123)(327,170)(433,170){5}
wire [31:0] w20;    //: /sn:0 {0}(484,376)(484,366){1}
//: {2}(486,364)(598,364)(598,449)(266,449)(266,401)(178,401){3}
//: {4}(482,364)(383,364){5}
wire [7:0] w1;    //: /sn:0 {0}(178,204)(253,204)(253,280)(379,280){1}
wire [7:0] w8;    //: /sn:0 /dp:7 {0}(395,280)(559,280)(559,172){1}
//: {2}(561,170)(614,170)(614,314)(226,314)(226,244)(178,244){3}
//: {4}(559,168)(559,93)(387,93)(387,78){5}
//: {6}(557,170)(468,170){7}
wire w12;    //: /sn:0 {0}(15,274)(60,274){1}
wire [7:0] w5;    //: /sn:0 /dp:2 {0}(3,156)(19,156){1}
//: {2}(23,156)(60,156){3}
//: {4}(21,154)(21,96){5}
wire w9;    //: /sn:0 /dp:1 {0}(14,240)(60,240){1}
//: enddecls

  //: joint g8 (w8) @(559, 170) /anc:1 /w:[ 2 4 6 1 ]
  //: supply0 g4 (w11) @(444,217) /sn:0 /anc:1 /w:[ 0 ]
  led g13 (.I(w5));   //: @(21,89) /sn:0 /anc:1 /w:[ 5 ] /type:2
  bufif1 g3 (.Z(w8), .I(w1), .E(w4));   //: @(385,280) /sn:0 /anc:1 /w:[ 0 1 13 ]
  //: comment g2 /dolink:0 /link:"" @(481,183) /sn:0 /anc:1
  //: /line:"DATA RAM"
  //: /end
  //: comment g1 /dolink:0 /link:"" @(385,347) /sn:0 /R:2 /anc:1
  //: /line:"Microcode ROM"
  //: /end
  //: comment g16 /dolink:0 /link:"" @(-47,48) /sn:0 /anc:1
  //: /line:"Addr"
  //: /end
  //: comment g11 /dolink:0 /link:"" @(-91,168) /sn:0 /anc:1
  //: /line:"Text ROM"
  //: /end
  led g28 (.I(w4));   //: @(451,116) /sn:0 /anc:1 /w:[ 5 ] /type:0
  cpu g10 (.rst(w12), .clk(w9), .PI(w5), .MD(w20), .DI(w8), .PA(w7), .DA(w0), .MA(w6), .DO(w1), .DWE(w4));   //: @(61, 74) /sz:(116, 360) /sn:0 /anc:1 /p:[ Li0>1 Li1>1 Li2>3 Ri0>3 Ri1>3 Lo0<0 Ro0<0 Ro1<0 Ro2<0 Ro3<11 ]
  //: joint g27 (w4) @(458, 209) /w:[ 2 1 -1 8 ]
  //: joint g19 (w0) @(327, 121) /anc:1 /w:[ -1 2 1 4 ]
  led g6 (.I(w8));   //: @(387,71) /sn:0 /anc:1 /w:[ 5 ] /type:2
  //: switch g9 (w12) @(-2,274) /sn:0 /anc:1 /w:[ 0 ] /st:0
  //: switch g7 (w9) @(-3,240) /sn:0 /anc:1 /w:[ 0 ] /st:1
  //: comment g20 /dolink:0 /link:"" @(315,29) /sn:0 /anc:1
  //: /line:"Addr"
  //: /end
  //: joint g15 (w5) @(21, 156) /anc:1 /w:[ 2 4 1 -1 ]
  //: joint g29 (w4) @(451, 137) /anc:1 /w:[ 3 4 -1 6 ]
  //: comment g17 /dolink:0 /link:"" @(6,48) /sn:0 /anc:1
  //: /line:"Inst"
  //: /end
  //: joint g25 (w20) @(484, 364) /w:[ 2 -1 4 1 ]
  //: joint g14 (w7) @(-34, 120) /anc:1 /w:[ 1 2 4 -1 ]
  //: supply0 g5 (w14) @(366,414) /sn:0 /anc:1 /w:[ 1 ]
  rom MicrocodeROM (.A(w6), .D(w20), .OE(w14));   //: @(366,365) /sn:0 /anc:1 /w:[ 3 5 0 ]
  led g24 (.I(w20));   //: @(484,383) /sn:0 /R:2 /anc:1 /w:[ 0 ] /type:2
  //: comment g21 /dolink:0 /link:"" @(371,29) /sn:0 /anc:1
  //: /line:"Data"
  //: /end
  ram DataRAM (.A(w0), .D(w8), .WE(!w4), .OE(w4), .CS(w11));   //: @(451,171) /sn:0 /anc:1 /w:[ 5 7 7 0 1 ]
  //: joint g23 (w6) @(310, 364) /anc:1 /w:[ 2 -1 1 4 ]
  //: joint g0 (w4) @(387, 196) /w:[ 9 -1 10 12 ]
  led g22 (.I(w6));   //: @(310,382) /sn:0 /R:2 /anc:1 /w:[ 5 ] /type:2
  //: supply0 g26 (w13) @(-14,205) /sn:0 /anc:1 /w:[ 1 ]
  led g18 (.I(w0));   //: @(327,71) /sn:0 /anc:1 /w:[ 3 ] /type:2
  led g12 (.I(w7));   //: @(-34,89) /sn:0 /anc:1 /w:[ 3 ] /type:2
  rom TextROM (.A(w7), .D(w5), .OE(w13));   //: @(-14,157) /sn:0 /anc:1 /w:[ 5 0 0 ]

endmodule
