# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class HeartbeatConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes.heartbeat_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _HeartbeatConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            site_id,
            enforcementpoint_id,
            cluster_control_plane_id,
            ):
        """
        Read Antrea heartbeat configuration

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cluster_control_plane_id: :class:`str`
        :param cluster_control_plane_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AntreaHeartbeatConfig`
        :return: com.vmware.nsx_policy.model.AntreaHeartbeatConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cluster_control_plane_id': cluster_control_plane_id,
                            })

    def patch(self,
              site_id,
              enforcementpoint_id,
              cluster_control_plane_id,
              antrea_heartbeat_config,
              ):
        """
        Patch the Antrea heartbeat configuration

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cluster_control_plane_id: :class:`str`
        :param cluster_control_plane_id: (required)
        :type  antrea_heartbeat_config: :class:`com.vmware.nsx_policy.model_client.AntreaHeartbeatConfig`
        :param antrea_heartbeat_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cluster_control_plane_id': cluster_control_plane_id,
                            'antrea_heartbeat_config': antrea_heartbeat_config,
                            })

    def update(self,
               site_id,
               enforcementpoint_id,
               cluster_control_plane_id,
               antrea_heartbeat_config,
               ):
        """
        Update the Antrea heartbeat configuration

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cluster_control_plane_id: :class:`str`
        :param cluster_control_plane_id: (required)
        :type  antrea_heartbeat_config: :class:`com.vmware.nsx_policy.model_client.AntreaHeartbeatConfig`
        :param antrea_heartbeat_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AntreaHeartbeatConfig`
        :return: com.vmware.nsx_policy.model.AntreaHeartbeatConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cluster_control_plane_id': cluster_control_plane_id,
                            'antrea_heartbeat_config': antrea_heartbeat_config,
                            })
class Status(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes.status'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatusStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            site_id,
            enforcementpoint_id,
            cluster_control_plane_id,
            ):
        """
        Read Antrea cluster status for a given Antrea cluster identifier.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cluster_control_plane_id: :class:`str`
        :param cluster_control_plane_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AntreaClusterInfo`
        :return: com.vmware.nsx_policy.model.AntreaClusterInfo
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cluster_control_plane_id': cluster_control_plane_id,
                            })
class _HeartbeatConfigStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cluster_control_plane_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/cluster-control-planes/{cluster-control-plane-id}/heartbeat-config',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'cluster_control_plane_id': 'cluster-control-plane-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cluster_control_plane_id': type.StringType(),
            'antrea_heartbeat_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AntreaHeartbeatConfig'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/cluster-control-planes/{cluster-control-plane-id}/heartbeat-config',
            request_body_parameter='antrea_heartbeat_config',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'cluster_control_plane_id': 'cluster-control-plane-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cluster_control_plane_id': type.StringType(),
            'antrea_heartbeat_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AntreaHeartbeatConfig'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/cluster-control-planes/{cluster-control-plane-id}/heartbeat-config',
            request_body_parameter='antrea_heartbeat_config',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'cluster_control_plane_id': 'cluster-control-plane-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AntreaHeartbeatConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AntreaHeartbeatConfig'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes.heartbeat_config',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cluster_control_plane_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/cluster-control-planes/{cluster-control-plane-id}/status',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'cluster_control_plane_id': 'cluster-control-plane-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AntreaClusterInfo'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes.status',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'HeartbeatConfig': HeartbeatConfig,
        'Status': Status,
    }

