# -*- coding: utf-8 -*-
"""This file contains the Basic Security Module definitions."""

from __future__ import unicode_literals


# Arbitrary tokens.
# Type of data to print in a BSM_TOKEN_DATA.
BSM_TOKEN_DATA_TYPE = {
    0: 'AUR_CHAR',
    1: 'AUR_SHORT',
    2: 'AUR_INT32'}

BSM_TOKEN_DATA_PRINT = {
    0: 'Binary',
    1: 'Octal',
    2: 'Decimal',
    3: 'Hexadecimal',
    4: 'String'}

# BSM identification errors.
BSM_ERRORS = {
    0: 'Success',
    1: 'Operation not permitted',
    2: 'No such file or directory',
    3: 'No such process',
    4: 'Interrupted system call',
    5: 'Input/output error',
    6: 'Device not configured',
    7: 'Argument list too long',
    8: 'Exec format error',
    9: 'Bad file descriptor',
    10: 'No child processes',
    11: 'Resource temporarily unavailable',
    12: 'Cannot allocate memory',
    13: 'Permission denied',
    14: 'Bad address',
    15: 'Block device required',
    16: 'Device busy',
    17: 'File exists',
    18: 'ross-device link',
    19: 'Operation not supported by device',
    20: 'Not a directory',
    21: 'Is a directory',
    22: 'Invalid argument',
    23: 'Too many open files in system',
    24: 'Too many open files',
    25: 'Inappropriate ioctl for device',
    26: 'Text file busy',
    27: 'File too large',
    28: 'No space left on device',
    29: 'Illegal seek',
    30: 'Read-only file system',
    31: 'Too many links',
    32: 'Broken pipe',
    33: 'Numerical argument out of domain',
    34: 'Result too large',
    35: 'No message of desired type',
    36: 'Identifier removed',
    45: 'Resource deadlock avoided',
    46: 'No locks available',
    47: 'Operation canceled',
    48: 'Operation not supported',
    49: 'Disc quota exceeded',
    66: 'Too many levels of remote in path',
    67: 'Link has been severed',
    71: 'Protocol error',
    74: 'Multihop attempted',
    77: 'Bad message',
    78: 'File name too long',
    79: 'Value too large to be stored in data type',
    88: 'Illegal byte sequence',
    89: 'Function not implemented',
    90: 'Too many levels of symbolic links',
    91: 'Restart syscall',
    93: 'Directory not empty',
    94: 'Too many users',
    95: 'Socket operation on non-socket',
    96: 'Destination address required',
    97: 'Message too long',
    98: 'Protocol wrong type for socket',
    99: 'Protocol not available',
    120: 'Protocol not supported',
    121: 'Socket type not supported',
    122: 'Operation not supported',
    123: 'Protocol family not supported',
    124: 'Address family not supported by protocol family',
    125: 'Address already in use',
    126: 'Can\'t assign requested address',
    127: 'Network is down',
    128: 'Network unreachable',
    129: 'Network dropped connection on reset',
    130: 'Software caused connection abort',
    131: 'Connection reset by peer',
    132: 'No buffer space available',
    133: 'Socket is already connected',
    134: 'Socket is not connected',
    143: 'Can\'t send after socket shutdown',
    144: 'Too many references: can\'t splice',
    145: 'Operation timed out',
    146: 'Connection refused',
    147: 'Host is down',
    148: 'No route to host',
    149: 'Operation already in progress',
    150: 'Operation now in progress',
    151: 'Stale NFS file handle',
    190: 'PROCLIM',
    191: 'BADRPC',
    192: 'RPCMISMATCH',
    193: 'PROGUNAVAIL',
    194: 'PROGMISMATCH',
    195: 'PROCUNAVAIL',
    196: 'FTYPE',
    197: 'AUTH',
    198: 'NEEDAUTH',
    199: 'NOATTR',
    200: 'DOOFUS',
    201: 'USTRETURN',
    202: 'NOIOCTL',
    203: 'DIRIOCTL',
    204: 'PWROFF',
    205: 'DEVERR',
    206: 'BADEXEC',
    207: 'BADARCH',
    208: 'SHLIBVERS',
    209: 'BADMACHO',
    210: 'POLICY'}

# BSM network protocols. The information comes from OpenBSD project,
# so it might not be directly applicable to MacOS.
BSM_PROTOCOLS = {
    0: 'UNSPEC',
    1: 'LOCAL',
    2: 'INET',
    3: 'IMPLINK',
    4: 'PUP',
    5: 'CHAOS',
    6: 'NS',
    8: 'ECMA',
    9: 'DATAKIT',
    10: 'CCITT',
    11: 'SNA',
    12: 'DECnet',
    13: 'DLI',
    14: 'LAT',
    15: 'HYLINK',
    16: 'APPLETALK',
    19: 'OSI',
    23: 'IPX',
    24: 'ROUTE',
    25: 'LINK',
    26: 'INET6',
    27: 'KEY',
    500: 'NETBIOS',
    501: 'ISO',
    502: 'XTP',
    503: 'COIP',
    504: 'CNT',
    505: 'RTIP',
    506: 'SIP',
    507: 'PIP',
    508: 'ISDN',
    509: 'E164',
    510: 'NATM',
    511: 'ATM',
    512: 'NETGRAPH',
    513: 'SLOW',
    514: 'CLUSTER',
    515: 'ARP',
    516: 'BLUETOOTH'}

# key event types.
BSM_AUDIT_EVENT = {
    0: 'indir system call',
    1: 'exit(2)',
    2: 'fork(2)',
    3: 'open(2) - attr only',
    4: 'creat(2)',
    5: 'link(2)',
    6: 'unlink(2)',
    7: 'exec(2)',
    8: 'chdir(2)',
    9: 'mknod(2)',
    10: 'chmod(2)',
    11: 'chown(2)',
    12: 'umount(2) - old version',
    13: 'junk',
    14: 'access(2)',
    15: 'kill(2)',
    16: 'stat(2)',
    17: 'lstat(2)',
    18: 'acct(2)',
    19: 'mctl(2)',
    20: 'reboot(2)',
    21: 'symlink(2)',
    22: 'readlink(2)',
    23: 'execve(2)',
    24: 'chroot(2)',
    25: 'vfork(2)',
    26: 'setgroups(2)',
    27: 'setpgrp(2)',
    28: 'swapon(2)',
    29: 'sethostname(2)',
    30: 'fcntl(2)',
    31: 'setpriority(2)',
    32: 'connect(2)',
    33: 'accept(2)',
    34: 'bind(2)',
    35: 'setsockopt(2)',
    36: 'vtrace(2)',
    37: 'settimeofday(2)',
    38: 'fchown(2)',
    39: 'fchmod(2)',
    40: 'setreuid(2)',
    41: 'setregid(2)',
    42: 'rename(2)',
    43: 'truncate(2)',
    44: 'ftruncate(2)',
    45: 'flock(2)',
    46: 'shutdown(2)',
    47: 'mkdir(2)',
    48: 'rmdir(2)',
    49: 'utimes(2)',
    50: 'adjtime(2)',
    51: 'setrlimit(2)',
    52: 'killpg(2)',
    53: 'nfs_svc(2)',
    54: 'statfs(2)',
    55: 'fstatfs(2)',
    56: 'unmount(2)',
    57: 'async_daemon(2)',
    58: 'nfs_getfh(2)',
    59: 'setdomainname(2)',
    60: 'quotactl(2)',
    61: 'exportfs(2)',
    62: 'mount(2)',
    63: 'semsys(2)',
    64: 'msgsys(2)',
    65: 'shmsys(2)',
    66: 'bsmsys(2)',
    67: 'rfssys(2)',
    68: 'fchdir(2)',
    69: 'fchroot(2)',
    70: 'vpixsys(2)',
    71: 'pathconf(2)',
    72: 'open(2) - read',
    73: 'open(2) - read,creat',
    74: 'open(2) - read,trunc',
    75: 'open(2) - read,creat,trunc',
    76: 'open(2) - write',
    77: 'open(2) - write,creat',
    78: 'open(2) - write,trunc',
    79: 'open(2) - write,creat,trunc',
    80: 'open(2) - read,write',
    81: 'open(2) - read,write,creat',
    82: 'open(2) - read,write,trunc',
    83: 'open(2) - read,write,creat,trunc',
    84: 'msgctl(2) - illegal command',
    85: 'msgctl(2) - IPC_RMID command',
    86: 'msgctl(2) - IPC_SET command',
    87: 'msgctl(2) - IPC_STAT command',
    88: 'msgget(2)',
    89: 'msgrcv(2)',
    90: 'msgsnd(2)',
    91: 'shmctl(2) - illegal command',
    92: 'shmctl(2) - IPC_RMID command',
    93: 'shmctl(2) - IPC_SET command',
    94: 'shmctl(2) - IPC_STAT command',
    95: 'shmget(2)',
    96: 'shmat(2)',
    97: 'shmdt(2)',
    98: 'semctl(2) - illegal command',
    99: 'semctl(2) - IPC_RMID command',
    100: 'semctl(2) - IPC_SET command',
    101: 'semctl(2) - IPC_STAT command',
    102: 'semctl(2) - GETNCNT command',
    103: 'semctl(2) - GETPID command',
    104: 'semctl(2) - GETVAL command',
    105: 'semctl(2) - GETALL command',
    106: 'semctl(2) - GETZCNT command',
    107: 'semctl(2) - SETVAL command',
    108: 'semctl(2) - SETALL command',
    109: 'semget(2)',
    110: 'semop(2)',
    111: 'process dumped core',
    112: 'close(2)',
    113: 'system booted',
    114: 'async_daemon(2) exited',
    115: 'nfssvc(2) exited',
    128: 'writel(2)',
    129: 'writevl(2)',
    130: 'getauid(2)',
    131: 'setauid(2)',
    132: 'getaudit(2)',
    133: 'setaudit(2)',
    134: 'getuseraudit(2)',
    135: 'setuseraudit(2)',
    136: 'auditsvc(2)',
    137: 'audituser(2)',
    138: 'auditon(2)',
    139: 'auditon(2) - GETTERMID command',
    140: 'auditon(2) - SETTERMID command',
    141: 'auditon(2) - GPOLICY command',
    142: 'auditon(2) - SPOLICY command',
    143: 'auditon(2) - GESTATE command',
    144: 'auditon(2) - SESTATE command',
    145: 'auditon(2) - GQCTRL command',
    146: 'auditon(2) - SQCTRL command',
    147: 'getkernstate(2)',
    148: 'setkernstate(2)',
    149: 'getportaudit(2)',
    150: 'auditstat(2)',
    151: 'revoke(2)',
    152: 'Solaris AUE_MAC',
    153: 'enter prom',
    154: 'exit prom',
    155: 'Solaris AUE_IFLOAT',
    156: 'Solaris AUE_PFLOAT',
    157: 'Solaris AUE_UPRIV',
    158: 'ioctl(2)',
    173: 'one-sided session record',
    174: 'msggetl(2)',
    175: 'msgrcvl(2)',
    176: 'msgsndl(2)',
    177: 'semgetl(2)',
    178: 'shmgetl(2)',
    183: 'socket(2)',
    184: 'sendto(2)',
    185: 'pipe(2)',
    186: 'socketpair(2)',
    187: 'send(2)',
    188: 'sendmsg(2)',
    189: 'recv(2)',
    190: 'recvmsg(2)',
    191: 'recvfrom(2)',
    192: 'read(2)',
    193: 'getdents(2)',
    194: 'lseek(2)',
    195: 'write(2)',
    196: 'writev(2)',
    197: 'nfs server',
    198: 'readv(2)',
    199: 'Solaris old stat(2)',
    200: 'setuid(2)',
    201: 'old stime(2)',
    202: 'old utime(2)',
    203: 'old nice(2)',
    204: 'Solaris old setpgrp(2)',
    205: 'setgid(2)',
    206: 'readl(2)',
    207: 'readvl(2)',
    208: 'fstat(2)',
    209: 'dup2(2)',
    210: 'mmap(2)',
    211: 'audit(2)',
    212: 'Solaris priocntlsys(2)',
    213: 'munmap(2)',
    214: 'setegid(2)',
    215: 'seteuid(2)',
    216: 'putmsg(2)',
    217: 'getmsg(2)',
    218: 'putpmsg(2)',
    219: 'getpmsg(2)',
    220: 'audit system calls place holder',
    221: 'auditon(2) - get kernel mask',
    222: 'auditon(2) - set kernel mask',
    223: 'auditon(2) - get cwd',
    224: 'auditon(2) - get car',
    225: 'auditon(2) - get audit statistics',
    226: 'auditon(2) - reset audit statistics',
    227: 'auditon(2) - set mask per uid',
    228: 'auditon(2) - set mask per session ID',
    229: 'auditon(2) - get audit state',
    230: 'auditon(2) - set audit state',
    231: 'auditon(2) - get event class',
    232: 'auditon(2) - set event class',
    233: 'utssys(2) - fusers',
    234: 'statvfs(2)',
    235: 'xstat(2)',
    236: 'lxstat(2)',
    237: 'lchown(2)',
    238: 'memcntl(2)',
    239: 'sysinfo(2)',
    240: 'xmknod(2)',
    241: 'fork1(2)',
    242: 'modctl(2) system call place holder',
    243: 'modctl(2) - load module',
    244: 'modctl(2) - unload module',
    245: 'modctl(2) - configure module',
    246: 'modctl(2) - bind module',
    247: 'getmsg-accept',
    248: 'putmsg-connect',
    249: 'putmsg-send',
    250: 'getmsg-receive',
    251: 'acl(2) - SETACL comand',
    252: 'facl(2) - SETACL command',
    253: 'doorfs(2) - system call place holder',
    254: 'doorfs(2) - DOOR_CALL',
    255: 'doorfs(2) - DOOR_RETURN',
    256: 'doorfs(2) - DOOR_CREATE',
    257: 'doorfs(2) - DOOR_REVOKE',
    258: 'doorfs(2) - DOOR_INFO',
    259: 'doorfs(2) - DOOR_CRED',
    260: 'doorfs(2) - DOOR_BIND',
    261: 'doorfs(2) - DOOR_UNBIND',
    262: 'p_online(2)',
    263: 'processor_bind(2)',
    264: 'inst_sync(2)',
    265: 'configure socket',
    266: 'setaudit_addr(2)',
    267: 'getaudit_addr(2)',
    268: 'Solaris umount(2)',
    269: 'fsat(2) - place holder',
    270: 'openat(2) - read',
    271: 'openat(2) - read,creat',
    272: 'openat(2) - read,trunc',
    273: 'openat(2) - read,creat,trunc',
    274: 'openat(2) - write',
    275: 'openat(2) - write,creat',
    276: 'openat(2) - write,trunc',
    277: 'openat(2) - write,creat,trunc',
    278: 'openat(2) - read,write',
    279: 'openat(2) - read,write,create',
    280: 'openat(2) - read,write,trunc',
    281: 'openat(2) - read,write,creat,trunc',
    282: 'renameat(2)',
    283: 'fstatat(2)',
    284: 'fchownat(2)',
    285: 'futimesat(2)',
    286: 'unlinkat(2)',
    287: 'clock_settime(2)',
    288: 'ntp_adjtime(2)',
    289: 'setppriv(2)',
    290: 'modctl(2) - configure device policy',
    291: 'modctl(2) - configure additional privilege',
    292: 'kernel cryptographic framework',
    293: 'configure kernel SSL',
    294: 'brandsys(2)',
    295: 'Add IPsec policy rule',
    296: 'Delete IPsec policy rule',
    297: 'Clone IPsec policy',
    298: 'Flip IPsec policy',
    299: 'Flush IPsec policy rules',
    300: 'Update IPsec algorithms',
    301: 'portfs',
    302: 'ptrace(2)',
    303: 'chflags(2)',
    304: 'fchflags(2)',
    305: 'profil(2)',
    306: 'ktrace(2)',
    307: 'setlogin(2)',
    308: 'reboot(2)',
    309: 'revoke(2)',
    310: 'umask(2)',
    311: 'mprotect(2)',
    312: 'setpriority(2)',
    313: 'settimeofday(2)',
    314: 'flock(2)',
    315: 'mkfifo(2)',
    316: 'poll(2)',
    317: 'socketpair(2)',
    318: 'futimes(2)',
    319: 'setsid(2)',
    320: 'setprivexec(2)',
    321: 'nfssvc(2)',
    322: 'getfh(2)',
    323: 'quotactl(2)',
    324: 'add_profil()',
    325: 'kdebug_trace()',
    326: 'fstat(2)',
    327: 'fpathconf(2)',
    328: 'getdirentries(2)',
    329: 'truncate(2)',
    330: 'ftruncate(2)',
    331: 'sysctl(3)',
    332: 'mlock(2)',
    333: 'munlock(2)',
    334: 'undelete(2)',
    335: 'getattrlist()',
    336: 'setattrlist()',
    337: 'getdirentriesattr()',
    338: 'exchangedata()',
    339: 'searchfs()',
    340: 'minherit(2)',
    341: 'semconfig()',
    342: 'sem_open(2)',
    343: 'sem_close(2)',
    344: 'sem_unlink(2)',
    345: 'shm_open(2)',
    346: 'shm_unlink(2)',
    347: 'load_shared_file()',
    348: 'reset_shared_file()',
    349: 'new_system_share_regions()',
    350: 'pthread_kill(2)',
    351: 'pthread_sigmask(2)',
    352: 'auditctl(2)',
    353: 'rfork(2)',
    354: 'lchmod(2)',
    355: 'swapoff(2)',
    356: 'init_process()',
    357: 'map_fd()',
    358: 'task_for_pid()',
    359: 'pid_for_task()',
    360: 'sysctl() - non-admin',
    361: 'copyfile()',
    43001: 'getfsstat(2)',
    43002: 'ptrace(2)',
    43003: 'chflags(2)',
    43004: 'fchflags(2)',
    43005: 'profil(2)',
    43006: 'ktrace(2)',
    43007: 'setlogin(2)',
    43008: 'revoke(2)',
    43009: 'umask(2)',
    43010: 'mprotect(2)',
    43011: 'mkfifo(2)',
    43012: 'poll(2)',
    43013: 'futimes(2)',
    43014: 'setsid(2)',
    43015: 'setprivexec(2)',
    43016: 'add_profil()',
    43017: 'kdebug_trace()',
    43018: 'fstat(2)',
    43019: 'fpathconf(2)',
    43020: 'getdirentries(2)',
    43021: 'sysctl(3)',
    43022: 'mlock(2)',
    43023: 'munlock(2)',
    43024: 'undelete(2)',
    43025: 'getattrlist()',
    43026: 'setattrlist()',
    43027: 'getdirentriesattr()',
    43028: 'exchangedata()',
    43029: 'searchfs()',
    43030: 'minherit(2)',
    43031: 'semconfig()',
    43032: 'sem_open(2)',
    43033: 'sem_close(2)',
    43034: 'sem_unlink(2)',
    43035: 'shm_open(2)',
    43036: 'shm_unlink(2)',
    43037: 'load_shared_file()',
    43038: 'reset_shared_file()',
    43039: 'new_system_share_regions()',
    43040: 'pthread_kill(2)',
    43041: 'pthread_sigmask(2)',
    43042: 'auditctl(2)',
    43043: 'rfork(2)',
    43044: 'lchmod(2)',
    43045: 'swapoff(2)',
    43046: 'init_process()',
    43047: 'map_fd()',
    43048: 'task_for_pid()',
    43049: 'pid_for_task()',
    43050: 'sysctl() - non-admin',
    43051: 'copyfile(2)',
    43052: 'lutimes(2)',
    43053: 'lchflags(2)',
    43054: 'sendfile(2)',
    43055: 'uselib(2)',
    43056: 'getresuid(2)',
    43057: 'setresuid(2)',
    43058: 'getresgid(2)',
    43059: 'setresgid(2)',
    43060: 'wait4(2)',
    43061: 'lgetfh(2)',
    43062: 'fhstatfs(2)',
    43063: 'fhopen(2)',
    43064: 'fhstat(2)',
    43065: 'jail(2)',
    43066: 'eaccess(2)',
    43067: 'kqueue(2)',
    43068: 'kevent(2)',
    43069: 'fsync(2)',
    43070: 'nmount(2)',
    43071: 'bdflush(2)',
    43072: 'setfsuid(2)',
    43073: 'setfsgid(2)',
    43074: 'personality(2)',
    43075: 'getscheduler(2)',
    43076: 'setscheduler(2)',
    43077: 'prctl(2)',
    43078: 'getcwd(2)',
    43079: 'capget(2)',
    43080: 'capset(2)',
    43081: 'pivot_root(2)',
    43082: 'rtprio(2)',
    43083: 'sched_getparam(2)',
    43084: 'sched_setparam(2)',
    43085: 'sched_get_priority_max(2)',
    43086: 'sched_get_priority_min(2)',
    43087: 'sched_rr_get_interval(2)',
    43088: 'acl_get_file(2)',
    43089: 'acl_set_file(2)',
    43090: 'acl_get_fd(2)',
    43091: 'acl_set_fd(2)',
    43092: 'acl_delete_file(2)',
    43093: 'acl_delete_fd(2)',
    43094: 'acl_aclcheck_file(2)',
    43095: 'acl_aclcheck_fd(2)',
    43096: 'acl_get_link(2)',
    43097: 'acl_set_link(2)',
    43098: 'acl_delete_link(2)',
    43099: 'acl_aclcheck_link(2)',
    43100: 'sysarch(2)',
    43101: 'extattrctl(2)',
    43102: 'extattr_get_file(2)',
    43103: 'extattr_set_file(2)',
    43104: 'extattr_list_file(2)',
    43105: 'extattr_delete_file(2)',
    43106: 'extattr_get_fd(2)',
    43107: 'extattr_set_fd(2)',
    43108: 'extattr_list_fd(2)',
    43109: 'extattr_delete_fd(2)',
    43110: 'extattr_get_link(2)',
    43111: 'extattr_set_link(2)',
    43112: 'extattr_list_link(2)',
    43113: 'extattr_delete_link(2)',
    43114: 'kenv(8)',
    43115: 'jail_attach(2)',
    43116: 'sysctl(3)',
    43117: 'linux ioperm',
    43118: 'readdir(3)',
    43119: 'linux iopl',
    43120: 'linux vm86',
    43121: 'mac_get_proc(2)',
    43122: 'mac_set_proc(2)',
    43123: 'mac_get_fd(2)',
    43124: 'mac_get_file(2)',
    43125: 'mac_set_fd(2)',
    43126: 'mac_set_file(2)',
    43127: 'mac_syscall(2)',
    43128: 'mac_get_pid(2)',
    43129: 'mac_get_link(2)',
    43130: 'mac_set_link(2)',
    43131: 'mac_execve(2)',
    43132: 'getpath_fromfd(2)',
    43133: 'getpath_fromaddr(2)',
    43134: 'mq_open(2)',
    43135: 'mq_setattr(2)',
    43136: 'mq_timedreceive(2)',
    43137: 'mq_timedsend(2)',
    43138: 'mq_notify(2)',
    43139: 'mq_unlink(2)',
    43140: 'listen(2)',
    43141: 'mlockall(2)',
    43142: 'munlockall(2)',
    43143: 'closefrom(2)',
    43144: 'fexecve(2)',
    43145: 'faccessat(2)',
    43146: 'fchmodat(2)',
    43147: 'linkat(2)',
    43148: 'mkdirat(2)',
    43149: 'mkfifoat(2)',
    43150: 'mknodat(2)',
    43151: 'readlinkat(2)',
    43152: 'symlinkat(2)',
    43153: 'mac_getfsstat(2)',
    43154: 'mac_get_mount(2)',
    43155: 'mac_get_lcid(2)',
    43156: 'mac_get_lctx(2)',
    43157: 'mac_set_lctx(2)',
    43158: 'mac_mount(2)',
    43159: 'getlcid(2)',
    43160: 'setlcid(2)',
    43161: 'taskname_for_pid()',
    43162: 'access_extended(2)',
    43163: 'chmod_extended(2)',
    43164: 'fchmod_extended(2)',
    43165: 'fstat_extended(2)',
    43166: 'lstat_extended(2)',
    43167: 'mkdir_extended(2)',
    43168: 'mkfifo_extended(2)',
    43169: 'open_extended(2) - attr only',
    43170: 'open_extended(2) - read',
    43171: 'open_extended(2) - read,creat',
    43172: 'open_extended(2) - read,trunc',
    43173: 'open_extended(2) - read,creat,trunc',
    43174: 'open_extended(2) - write',
    43175: 'open_extended(2) - write,creat',
    43176: 'open_extended(2) - write,trunc',
    43177: 'open_extended(2) - write,creat,trunc',
    43178: 'open_extended(2) - read,write',
    43179: 'open_extended(2) - read,write,creat',
    43180: 'open_extended(2) - read,write,trunc',
    43181: 'open_extended(2) - read,write,creat,trunc',
    43182: 'stat_extended(2)',
    43183: 'umask_extended(2)',
    43184: 'openat(2) - attr only',
    43185: 'posix_openpt(2)',
    43186: 'cap_new(2)',
    43187: 'cap_getrights(2)',
    43188: 'cap_enter(2)',
    43189: 'cap_getmode(2)',
    43190: 'posix_spawn(2)',
    43191: 'fsgetpath(2)',
    43192: 'pread(2)',
    43193: 'pwrite(2)',
    43194: 'fsctl()',
    43195: 'ffsctl()',
    43196: 'lpathconf(2)',
    43197: 'pdfork(2)',
    43198: 'pdkill(2)',
    43199: 'pdgetpid(2)',
    43200: 'pdwait(2)',
    44901: 'session start',
    44902: 'session update',
    44903: 'session end',
    44904: 'session close',
    6144: 'at-create atjob',
    6145: 'at-delete atjob (at or atrm)',
    6146: 'at-permission',
    6147: 'cron-invoke',
    6148: 'crontab-crontab created',
    6149: 'crontab-crontab deleted',
    6150: 'crontab-permission',
    6151: 'inetd connection',
    6152: 'login - local',
    6153: 'logout - local',
    6154: 'login - telnet',
    6155: 'login - rlogin',
    6156: 'mount',
    6157: 'unmount',
    6158: 'rsh access',
    6159: 'su(1)',
    6160: 'system halt',
    6161: 'system reboot',
    6162: 'rexecd',
    6163: 'passwd',
    6164: 'rexd',
    6165: 'ftp access',
    6166: 'init',
    6167: 'uadmin',
    6168: 'system shutdown',
    6170: 'crontab-modify',
    6171: 'ftp logout',
    6172: 'login - ssh',
    6173: 'role login',
    6180: ' profile command',
    6181: 'add filesystem',
    6182: 'delete filesystem',
    6183: 'modify filesystem',
    6200: 'allocate-device success',
    6201: 'allocate-device failure',
    6202: 'deallocate-device success',
    6203: 'deallocate-device failure',
    6204: 'allocate-list devices success',
    6205: 'allocate-list devices failure',
    6207: 'create user',
    6208: 'modify user',
    6209: 'delete user',
    6210: 'disable user',
    6211: 'enable user',
    6212: 'newgrp login',
    6213: 'admin login',
    6214: 'authenticated kadmind request',
    6215: 'unauthenticated kadmind req',
    6216: 'kdc authentication svc request',
    6217: 'kdc tkt-grant svc request',
    6218: 'kdc tgs 2ndtkt mismtch',
    6219: 'kdc tgs issue alt tgt',
    6300: 'sudo(1)',
    6501: 'modify password',
    6511: 'create group',
    6512: 'delete group',
    6513: 'modify group',
    6514: 'add to group',
    6515: 'remove from group',
    6521: 'revoke object priv',
    6600: 'loginwindow login',
    6601: 'loginwindow logout',
    7000: 'user authentication',
    7001: 'SecSrvr connection setup',
    7002: 'SecSrvr AuthEngine',
    7003: 'SecSrvr authinternal mech',
    32800: 'OpenSSH login',
    45000: 'audit startup',
    45001: 'audit shutdown',
    45014: 'modify password',
    45015: 'create group',
    45016: 'delete group',
    45017: 'modify group',
    45018: 'add to group',
    45019: 'remove from group',
    45020: 'revoke object priv',
    45021: 'loginwindow login',
    45022: 'loginwindow logout',
    45023: 'user authentication',
    45024: 'SecSrvr connection setup',
    45025: 'SecSrvr AuthEngine',
    45026: 'SecSrvr authinternal mech',
    45027: 'Calife',
    45028: 'sudo(1)',
    45029: 'audit crash recovery',
    45030: 'SecSrvr AuthMechanism',
    45031: 'Security Assessment'
}
