/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.TraceRegion;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;

public class CharSequenceTraceWrapper {
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private IProjectConfigProvider projectConfigProvider;

    public CharSequence wrapWithTraceData(CharSequence sequence, EObject origin) {
        ITextRegionWithLineInformation location = (ITextRegionWithLineInformation)this.locationInFileProvider.getSignificantTextRegion(origin);
        AbsoluteURI absoluteURI = new AbsoluteURI(origin.eResource().getURI());
        IProjectConfig projectConfig = this.projectConfigProvider.getProjectConfig(EcoreUtil2.getResourceSet((Notifier)origin));
        SourceRelativeURI sourceRelativeURI = absoluteURI.deresolve(projectConfig);
        return this.wrapWithTraceData(sequence, sourceRelativeURI, location.getOffset(), location.getLength(), location.getLineNumber(), location.getEndLineNumber());
    }

    public CharSequence wrapWithTraceData(CharSequence sequence, SourceRelativeURI originResourceURI, int originOffset, int originLength, int originLineNumber, int originEndLineNumber) {
        return this.wrapWithTraceData(sequence, originResourceURI, originResourceURI.getURI().segment(1), originOffset, originLength, originLineNumber, originEndLineNumber);
    }

    public CharSequence wrapWithTraceData(CharSequence sequence, SourceRelativeURI originURI, String originProject, int originOffset, int originLength, int originLineNumber, int originEndLineNumber) {
        return new CharSequenceBasedTraceRegionProvider(sequence, originURI, originOffset, originLength, originLineNumber, originEndLineNumber);
    }

    protected static class CharSequenceBasedTraceRegionProvider
    implements ITraceRegionProvider,
    CharSequence {
        private final CharSequence delegate;
        private final SourceRelativeURI originURI;
        private final int originOffset;
        private final int originLength;
        private final int originLineNumber;
        private final int originEndLineNumber;

        public CharSequenceBasedTraceRegionProvider(CharSequence delegate, SourceRelativeURI originURI, int originOffset, int originLength, int originLineNumber, int originEndLineNumber) {
            this.delegate = delegate;
            this.originURI = originURI;
            this.originOffset = originOffset;
            this.originLength = originLength;
            this.originLineNumber = originLineNumber;
            this.originEndLineNumber = originEndLineNumber;
        }

        @Override
        public int length() {
            return this.delegate.length();
        }

        @Override
        public char charAt(int index) {
            return this.delegate.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.delegate.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public AbstractTraceRegion getTraceRegion() {
            LocationData locationData = new LocationData(this.originOffset, this.originLength, this.originLineNumber, this.originEndLineNumber, this.originURI);
            TraceRegion result = new TraceRegion(0, this.delegate.length(), 0, Strings.countLineBreaks((CharSequence)this.delegate), true, locationData, null);
            return result;
        }
    }
}

