/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus;

import java.util.BitSet;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class BitArray
implements Iterable<Boolean> {
    private final BitSet wrapped;
    private final int length;

    public BitArray(int nbits) {
        this(new BitSet(nbits), nbits);
    }

    public BitArray(boolean ... bits) {
        this(BitArray.bitSetFromBooleans(bits), bits.length);
    }

    public BitArray(BitSet wrapped, int length) {
        this.wrapped = wrapped;
        this.length = length;
    }

    private static BitSet bitSetFromBooleans(boolean ... bits) {
        BitSet bitSet = new BitSet(bits.length);
        int i = 0;
        while (i < bits.length) {
            bitSet.set(i, bits[i]);
            ++i;
        }
        return bitSet;
    }

    private boolean sizeAndValuesEquals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BitArray)) {
            return false;
        }
        BitArray other = (BitArray)obj;
        if (this.size() != other.size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            if (this.getBit(i) != other.getBit(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean getBit(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.wrapped.get(index);
    }

    public void setBit(int index, boolean value) {
        if (value) {
            this.wrapped.set(index);
        } else {
            this.wrapped.clear(index);
        }
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return "BitArray(bits=" + (this.length == 0 ? "<empty>" : this.toBinaryString()) + ")";
    }

    @Override
    public Iterator<Boolean> iterator() {
        return IntStream.range(0, this.size()).mapToObj(this::getBit).iterator();
    }

    public boolean equals(@Nullable Object obj) {
        return this.sizeAndValuesEquals(obj);
    }

    public String toBinaryString() {
        StringBuilder buffer = new StringBuilder(this.size());
        IntStream.range(0, this.size()).mapToObj(i -> Character.valueOf(this.getBit(i) ? (char)'1' : (char)'0')).forEach(buffer::append);
        return buffer.toString();
    }
}

