/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.type.Input;
import org.openhab.core.automation.type.Output;
import org.openhab.core.i18n.I18nUtil;
import org.openhab.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class ModuleTypeI18nUtil {
    public static final String MODULE_TYPE = "module-type";
    private final TranslationProvider i18nProvider;

    public ModuleTypeI18nUtil(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    public @Nullable String getLocalizedModuleTypeLabel(Bundle bundle, String moduleTypeUID, @Nullable String defaultLabel, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> this.inferModuleTypeKey(moduleTypeUID, "label"));
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    public @Nullable String getLocalizedModuleTypeDescription(Bundle bundle, String moduleTypeUID, @Nullable String defaultDescription, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> this.inferModuleTypeKey(moduleTypeUID, "description"));
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    public List<Input> getLocalizedInputs(@Nullable List<Input> inputs, Bundle bundle, String uid, @Nullable Locale locale) {
        ArrayList<Input> linputs = new ArrayList<Input>();
        if (inputs != null) {
            for (Input input : inputs) {
                String inputName = input.getName();
                String ilabel = this.getInputLabel(bundle, uid, inputName, input.getLabel(), locale);
                String idescription = this.getInputDescription(bundle, uid, inputName, input.getDescription(), locale);
                linputs.add(new Input(inputName, input.getType(), ilabel, idescription, input.getTags(), input.isRequired(), input.getReference(), input.getDefaultValue()));
            }
        }
        return linputs;
    }

    public List<Output> getLocalizedOutputs(@Nullable List<Output> outputs, Bundle bundle, String uid, @Nullable Locale locale) {
        ArrayList<Output> loutputs = new ArrayList<Output>();
        if (outputs != null) {
            for (Output output : outputs) {
                String outputName = output.getName();
                String olabel = this.getOutputLabel(bundle, uid, outputName, output.getLabel(), locale);
                String odescription = this.getOutputDescription(bundle, uid, outputName, output.getDescription(), locale);
                loutputs.add(new Output(outputName, output.getType(), olabel, odescription, output.getTags(), output.getReference(), output.getDefaultValue()));
            }
        }
        return loutputs;
    }

    private @Nullable String getInputLabel(Bundle bundle, String moduleTypeUID, String inputName, @Nullable String defaultLabel, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> this.inferInputKey(moduleTypeUID, inputName, "label"));
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    private @Nullable String getInputDescription(Bundle bundle, String moduleTypeUID, String inputName, @Nullable String defaultDescription, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> this.inferInputKey(moduleTypeUID, inputName, "description"));
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    private @Nullable String getOutputLabel(Bundle bundle, String ruleTemplateUID, String outputName, String defaultLabel, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> this.inferOutputKey(ruleTemplateUID, outputName, "label"));
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    private @Nullable String getOutputDescription(Bundle bundle, String moduleTypeUID, String outputName, String defaultDescription, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> this.inferOutputKey(moduleTypeUID, outputName, "description"));
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    private String inferModuleTypeKey(String moduleTypeUID, String lastSegment) {
        return "module-type." + moduleTypeUID + "." + lastSegment;
    }

    private String inferInputKey(String moduleTypeUID, String inputName, String lastSegment) {
        return "module-type." + moduleTypeUID + ".input." + inputName + "." + lastSegment;
    }

    private String inferOutputKey(String moduleTypeUID, String outputName, String lastSegment) {
        return "module-type." + moduleTypeUID + ".output." + outputName + "." + lastSegment;
    }
}

