/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.internal.commands.AutomationCommand;
import org.openhab.core.automation.internal.commands.AutomationCommandsPluggable;

@NonNullByDefault
public class AutomationCommandImport
extends AutomationCommand {
    private static final String OPTION_P = "-p";
    private String parserType = "json";
    private @Nullable URL url;

    public AutomationCommandImport(String command, String[] params, int adminType, AutomationCommandsPluggable autoCommands) {
        super(command, params, adminType, autoCommands);
    }

    @Override
    public String execute() {
        URL url = this.url;
        if (!"SUCCESS".equals(this.parsingResult) || url == null) {
            return this.parsingResult;
        }
        try {
            switch (this.providerType) {
                case 3: {
                    this.autoCommands.importModuleTypes(this.parserType, url);
                    break;
                }
                case 2: {
                    this.autoCommands.importTemplates(this.parserType, url);
                    break;
                }
                case 1: {
                    this.autoCommands.importRules(this.parserType, url);
                }
            }
        }
        catch (Exception e) {
            return this.getStackTrace(e);
        }
        return "SUCCESS\n";
    }

    private @Nullable URL initURL(String parameterValue) {
        try {
            return new URL(parameterValue);
        }
        catch (MalformedURLException mue) {
            File f = new File(parameterValue);
            if (f.isFile()) {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    @Override
    protected String parseOptionsAndParameters(String[] parameterValues) {
        boolean getUrl = true;
        int i = 0;
        while (i < parameterValues.length) {
            if (parameterValues[i] != null) {
                if ("-st".equals(parameterValues[i])) {
                    this.st = true;
                } else if (OPTION_P.equalsIgnoreCase(parameterValues[i])) {
                    if (++i >= parameterValues.length) {
                        return String.format("The option [%s] should be followed by value for the parser type.", OPTION_P);
                    }
                    this.parserType = parameterValues[i];
                } else {
                    if (parameterValues[i].charAt(0) == '-') {
                        return String.format("Unsupported option: %s", parameterValues[i]);
                    }
                    if (getUrl) {
                        this.url = this.initURL(parameterValues[i]);
                        if (this.url != null) {
                            getUrl = false;
                        }
                    } else {
                        return String.format("Unsupported parameter: %s", parameterValues[i]);
                    }
                }
            }
            ++i;
        }
        if (getUrl) {
            return "Missing source URL parameter or its value is incorrect!";
        }
        return "SUCCESS";
    }
}

