/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.RuleStatusDetail;

@NonNullByDefault
public class RuleStatusInfo {
    @NonNullByDefault(value={})
    private RuleStatus status;
    @NonNullByDefault(value={})
    private RuleStatusDetail statusDetail;
    private @Nullable String description;

    protected RuleStatusInfo() {
    }

    public RuleStatusInfo(RuleStatus status) {
        this(status, RuleStatusDetail.NONE);
    }

    public RuleStatusInfo(RuleStatus status, RuleStatusDetail statusDetail) {
        this(status, statusDetail, null);
    }

    public RuleStatusInfo(RuleStatus status, RuleStatusDetail statusDetail, @Nullable String description) {
        this.status = status;
        this.statusDetail = statusDetail;
        this.description = description;
    }

    public RuleStatus getStatus() {
        return this.status;
    }

    public RuleStatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public String toString() {
        boolean hasDescription = this.getDescription() != null && !this.getDescription().isEmpty();
        return String.valueOf((Object)this.getStatus()) + (String)(this.getStatusDetail() == RuleStatusDetail.NONE ? "" : " (" + String.valueOf((Object)this.getStatusDetail()) + ")") + (String)(hasDescription ? ": " + this.getDescription() : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.statusDetail == null ? 0 : this.statusDetail.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleStatusInfo other = (RuleStatusInfo)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.statusDetail == other.statusDetail;
    }
}

