/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.rulesupport.shared;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleProvider;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.common.registry.ManagedProvider;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(immediate=true, service={ScriptedRuleProvider.class, RuleProvider.class})
public class ScriptedRuleProvider
extends AbstractProvider<Rule>
implements RuleProvider,
ManagedProvider<Rule, String> {
    private final Map<String, Rule> rules = new HashMap<String, Rule>();

    public Collection<Rule> getAll() {
        return this.rules.values();
    }

    public @Nullable Rule get(String ruleUID) {
        return this.rules.get(ruleUID);
    }

    public void add(Rule rule) {
        this.rules.put(rule.getUID(), rule);
        this.notifyListenersAboutAddedElement(rule);
    }

    @Deprecated
    public void addRule(Rule rule) {
        this.add(rule);
    }

    public @Nullable Rule update(Rule rule) {
        Rule oldRule = this.rules.get(rule.getUID());
        if (oldRule != null) {
            this.rules.put(rule.getUID(), rule);
            this.notifyListenersAboutUpdatedElement(oldRule, rule);
        }
        return oldRule;
    }

    public @Nullable Rule remove(String ruleUID) {
        Rule rule = this.rules.remove(ruleUID);
        if (rule != null) {
            this.notifyListenersAboutRemovedElement(rule);
        }
        return rule;
    }

    @Deprecated
    public void removeRule(String ruleUID) {
        this.remove(ruleUID);
    }

    public void removeRule(Rule rule) {
        this.remove(rule.getUID());
    }
}

