/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.rulesupport.internal.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public class BidiSetBag<K, V> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<K, Set<V>> keyToValues = new HashMap<K, Set<V>>();
    private final Map<V, Set<K>> valueToKeys = new HashMap<V, Set<K>>();

    public void put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            this.keyToValues.computeIfAbsent(key, k -> new HashSet()).add(value);
            this.valueToKeys.computeIfAbsent((Set)value, (Function<Set, Set<Object>>)((Function<Object, Set>)v -> new HashSet())).add(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<V> getValues(K key) {
        this.lock.readLock().lock();
        try {
            Set values = this.keyToValues.getOrDefault(key, Set.of());
            Set set = Collections.unmodifiableSet(values);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<K> getKeys(V value) {
        this.lock.readLock().lock();
        try {
            Set keys = this.valueToKeys.getOrDefault(value, Set.of());
            Set set = Collections.unmodifiableSet(keys);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<V> removeKey(K key) {
        this.lock.writeLock().lock();
        try {
            Set<V> values = this.keyToValues.remove(key);
            if (values != null) {
                for (V value : values) {
                    this.valueToKeys.computeIfPresent((Set)value, (BiFunction<Set, Set<Object>, Set<Object>>)((BiFunction<Object, Set, Set>)(k, v) -> {
                        v.remove(key);
                        return v;
                    }));
                }
                Set<V> set = values;
                return set;
            }
            Set set = Set.of();
            return set;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<K> removeValue(V value) {
        this.lock.writeLock().lock();
        try {
            Set<K> keys = this.valueToKeys.remove(value);
            if (keys != null) {
                for (K key : keys) {
                    this.keyToValues.computeIfPresent(key, (k, v) -> {
                        v.remove(value);
                        return v;
                    });
                }
                Set<K> set = keys;
                return set;
            }
            Set set = Set.of();
            return set;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

