/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.util;

import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final Bundle BUNDLE = FrameworkUtil.getBundle(Utils.class);

    private Utils() {
    }

    public static boolean same(Dictionary<String, ?> cfg1, Dictionary<String, ?> cfg2) {
        Object v2;
        String key;
        Object v1;
        if (cfg1 == null) {
            return cfg2 == null;
        }
        if (cfg2 == null) {
            return false;
        }
        if (cfg1.size() != cfg2.size()) {
            return false;
        }
        boolean result = true;
        Enumeration<String> keys = cfg1.keys();
        while (keys.hasMoreElements() && (result = Objects.equals(v1 = cfg1.get(key = keys.nextElement()), v2 = cfg2.get(key)))) {
        }
        return result;
    }

    public static boolean same(Object v1, Object v2) {
        return Objects.equals(v1, v2);
    }

    public static Map<String, String> toMap(Dictionary<?, ?> dictionary) {
        HashMap<String, String> converted = new HashMap<String, String>();
        if (dictionary != null) {
            Enumeration<?> enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                String key = k instanceof String ? (String)k : k.toString();
                String value = v instanceof String ? (String)v : (v == null ? null : v.toString());
                converted.put(key, value);
            }
        }
        return converted;
    }

    public static Hashtable<String, Object> toHashtable(Dictionary<String, ?> dictionary) {
        Hashtable<String, Object> converted = new Hashtable<String, Object>();
        if (dictionary != null) {
            Enumeration<String> enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String k = enumeration.nextElement();
                Object v = dictionary.get(k);
                converted.put(k, v);
            }
        }
        return converted;
    }

    public static Map<String, String> toMap(ServiceReference<?> reference) {
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        for (String key : reference.getPropertyKeys()) {
            ((Dictionary)dict).put(key, reference.getProperty(key));
        }
        return Utils.toMap(dict);
    }

    public static String resolve(String value) {
        return Utils.resolve(value, null);
    }

    public static String resolve(String value, String defaultValue) {
        return Utils.resolve(Collections.emptyMap(), value, defaultValue);
    }

    public static String resolve(Map<String, String> properties, String value, String defaultValue) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("_v", value);
        props.putAll(properties);
        InterpolationHelper.performSubstitution(props, BUNDLE == null ? null : BUNDLE.getBundleContext());
        return (String)props.get("_v");
    }

    public static long getServiceId(ServiceReference<WebContainer> ref) {
        Object idProperty = ref.getProperty("service.id");
        if (idProperty instanceof Long) {
            return (Long)idProperty;
        }
        return -1L;
    }

    public static Filter createFilter(BundleContext bundleContext, Class<?> ... trackedClass) {
        String filter;
        if (trackedClass.length == 0) {
            throw new IllegalArgumentException("No class specified to create objectClass-based filter.");
        }
        if (trackedClass.length == 1) {
            filter = "(objectClass=" + trackedClass[0].getName() + ")";
        } else {
            StringBuilder filterBuilder = new StringBuilder();
            filterBuilder.append("(|");
            for (Class<?> clazz : trackedClass) {
                filterBuilder.append("(").append("objectClass").append("=").append(clazz.getName()).append(")");
            }
            filterBuilder.append(")");
            filter = filterBuilder.toString();
        }
        try {
            return bundleContext.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    public static String[] getObjectClasses(ServiceReference<?> ref) {
        Object objectClass = ref.getProperty("objectClass");
        Object className = null;
        if (objectClass instanceof String) {
            return new String[]{(String)objectClass};
        }
        if (objectClass instanceof String[] && ((String[])objectClass).length > 0) {
            return (String[])objectClass;
        }
        LOG.warn("Service reference without \"objectClass\" property: {}", ref);
        return new String[0];
    }

    public static String getFirstObjectClass(ServiceReference<?> ref) {
        Object objectClass = ref.getProperty("objectClass");
        String className = null;
        if (objectClass instanceof String) {
            className = (String)objectClass;
        } else if (objectClass instanceof String[] && ((String[])objectClass).length > 0) {
            className = ((String[])objectClass)[0];
        }
        return className;
    }

    public static String getStringProperty(ServiceReference<?> serviceReference, String key) {
        Utils.validate(serviceReference, key);
        return Utils.asString(key, serviceReference.getProperty(key));
    }

    public static String asString(String propertyName, Object value) {
        if (value != null && !(value instanceof String)) {
            LOG.warn("Property {} should be String, but was {}", (Object)propertyName, (Object)value.getClass().getName());
            return null;
        }
        return (String)value;
    }

    public static Integer getIntegerProperty(ServiceReference<?> serviceReference, String key) {
        Utils.validate(serviceReference, key);
        return Utils.asInteger(key, serviceReference.getProperty(key));
    }

    public static Integer asInteger(String propertyName, Object value) {
        if (value != null && !(value instanceof String) && !(value instanceof Integer)) {
            LOG.warn("Property {} should be String or Integer, but was {}", (Object)propertyName, (Object)value.getClass().getName());
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return value == null ? null : Integer.valueOf((String)value);
    }

    public static Long getLongProperty(ServiceReference<?> serviceReference, String key) {
        Utils.validate(serviceReference, key);
        return Utils.asLong(key, serviceReference.getProperty(key));
    }

    public static Long asLong(String propertyName, Object value) {
        if (value != null && !(value instanceof String) && !(value instanceof Long)) {
            LOG.warn("Property {} should be String or Long, but was {}", (Object)propertyName, (Object)value.getClass().getName());
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return value == null ? null : Long.valueOf((String)value);
    }

    public static Boolean getBooleanProperty(ServiceReference<?> serviceReference, String key) {
        Utils.validate(serviceReference, key);
        return Utils.asBoolean(key, serviceReference.getProperty(key));
    }

    public static Boolean asBoolean(String propertyName, Object value) {
        if (value != null && !(value instanceof String) && !(value instanceof Boolean)) {
            LOG.warn("Property {} should be String or Boolean, but was {}", (Object)propertyName, (Object)value.getClass().getName());
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf((String)value);
    }

    private static void validate(ServiceReference<?> serviceReference, String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key has to be specified");
        }
        if (serviceReference == null) {
            throw new IllegalArgumentException("ServiceReference has to be specified");
        }
    }

    public static String[] asStringArray(String propertyName, Object value) {
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String) {
            return new String[]{((String)value).trim()};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Collection) {
            Collection collectionValues = (Collection)value;
            String[] values = new String[collectionValues.size()];
            int i = 0;
            for (Object current : collectionValues) {
                values[i++] = current != null ? String.valueOf(current).trim() : null;
            }
            return values;
        }
        LOG.warn("Property {} should be String/String[]/Collection<String>, but was {}", (Object)propertyName, (Object)value.getClass().getName());
        return new String[0];
    }

    public static String[] asStringArray(String propertyName, Object value, boolean splitStrings) {
        if (!splitStrings || !(value instanceof String)) {
            return Utils.asStringArray(propertyName, value);
        }
        return ((String)value).trim().split("\\s*,\\s*");
    }

    public static <T> T getPaxWebProperty(ServiceReference<?> serviceReference, String legacyName, String whiteboardName, BiFunction<String, Object, T> propertyProvider) {
        Object propertyValue;
        T value = null;
        if (legacyName != null && (propertyValue = serviceReference.getProperty(legacyName)) != null && whiteboardName != null) {
            LOG.warn("Legacy {} property specified, R7 {} property should be used instead", (Object)legacyName, (Object)whiteboardName);
            value = propertyProvider.apply(legacyName, propertyValue);
        }
        if (whiteboardName != null && (propertyValue = serviceReference.getProperty(whiteboardName)) != null) {
            if (value != null) {
                LOG.warn("Both legacy {} and R7 {} properties are specified. Using R7 property: {}.", new Object[]{legacyName, whiteboardName, propertyValue});
            }
            value = propertyProvider.apply(whiteboardName, propertyValue);
        }
        return value;
    }

    public static OsgiContextModel getHighestRankedModel(Set<OsgiContextModel> rankedSet) {
        if (rankedSet == null) {
            return null;
        }
        Iterator<OsgiContextModel> it = rankedSet.iterator();
        return it.hasNext() ? it.next() : null;
    }

    public static boolean isBundleProtocol(URL url) {
        if (url == null) {
            return false;
        }
        String protocol = url.getProtocol();
        return "bundle".equals(protocol) || "bundleresource".equals(protocol) || "bundleentry".equals(protocol);
    }

    public static Bundle getPaxWebJspBundle(BundleContext bundleContext) {
        if (bundleContext == null) {
            return null;
        }
        for (Bundle b : bundleContext.getBundles()) {
            if (!"org.ops4j.pax.web.pax-web-jsp".equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    public static Bundle getPaxWebJspBundle(Bundle bundle) {
        BundleContext ctx;
        BundleContext bundleContext = ctx = bundle == null ? null : bundle.getBundleContext();
        if (ctx == null) {
            return null;
        }
        for (Bundle b : ctx.getBundles()) {
            if (!"org.ops4j.pax.web.pax-web-jsp".equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    public static Bundle getJettyWebSocketBundle(Bundle bundle) {
        BundleContext ctx;
        BundleContext bundleContext = ctx = bundle == null ? null : bundle.getBundleContext();
        if (ctx == null) {
            return null;
        }
        Bundle[] bundles = new Bundle[]{null, null};
        for (Bundle b : ctx.getBundles()) {
            if (!"org.eclipse.jetty.websocket.javax.websocket.server".equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    public static Bundle getTomcatWebSocketBundle(Bundle bundle) {
        BundleContext ctx;
        BundleContext bundleContext = ctx = bundle == null ? null : bundle.getBundleContext();
        if (ctx == null) {
            return null;
        }
        for (Bundle b : ctx.getBundles()) {
            if (!"org.ops4j.pax.web.pax-web-tomcat-websocket".equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    public static Bundle getUndertowWebSocketBundle(Bundle bundle) {
        BundleContext ctx;
        BundleContext bundleContext = ctx = bundle == null ? null : bundle.getBundleContext();
        if (ctx == null) {
            return null;
        }
        for (Bundle b : ctx.getBundles()) {
            if (!"org.ops4j.pax.web.pax-web-undertow-websocket".equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    public static Bundle getPaxWebUndertowWebSocketBundle(Bundle bundle) {
        BundleContext ctx;
        BundleContext bundleContext = ctx = bundle == null ? null : bundle.getBundleContext();
        if (ctx == null) {
            return null;
        }
        for (Bundle b : ctx.getBundles()) {
            if (!"io.undertow.websockets-jsr".equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    public static Bundle getPaxWebWebSocketsBundle(Bundle bundle) {
        BundleContext ctx;
        BundleContext bundleContext = ctx = bundle == null ? null : bundle.getBundleContext();
        if (ctx == null) {
            return null;
        }
        for (Bundle b : ctx.getBundles()) {
            if (!"org.ops4j.pax.web.pax-web-websocket".equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    public static String getManifestHeader(Bundle bundle, String key) {
        List wires;
        if (bundle == null || bundle.getHeaders() == null) {
            return null;
        }
        String header = (String)bundle.getHeaders().get(key);
        if (header != null) {
            return header;
        }
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null && (wires = wiring.getProvidedWires("osgi.wiring.host")) != null) {
            for (BundleWire wire : wires) {
                Bundle b = wire.getRequirerWiring().getBundle();
                if (b == null || b.getHeaders() == null || (header = (String)b.getHeaders().get(key)) == null) continue;
                return header;
            }
        }
        return null;
    }

    public static boolean isFragment(Bundle bundle) {
        return bundle != null && bundle.adapt(BundleRevision.class) != null && (((BundleRevision)bundle.adapt(BundleRevision.class)).getTypes() & 1) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirectory(URL location) {
        if ("file".equals(location.getProtocol())) {
            try {
                return new File(location.toURI()).isDirectory();
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        try (InputStream is = location.openStream();){
            if (is == null) return false;
            if (is.available() != 0) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static boolean useSameContextPath(ElementModel<?, ?> model1, ElementModel<?, ?> model2) {
        for (OsgiContextModel cm1 : model1.getContextModels()) {
            for (OsgiContextModel cm2 : model2.getContextModels()) {
                if (!cm1.getContextPath().equals(cm2.getContextPath())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isConfigurationAdminAvailable(Class<?> cls) {
        try {
            cls.getClassLoader().loadClass("org.osgi.service.cm.ConfigurationAdmin");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isEventAdminAvailable(Class<?> cls) {
        try {
            cls.getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    public static boolean isJasyptAvailable(Class<?> cls) {
        try {
            cls.getClassLoader().loadClass("org.jasypt.encryption.StringEncryptor");
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

