/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.task;

import java.util.Arrays;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.OpCode;

public class EventListenerModelChange
extends Change {
    private final List<EventListenerModel> eventListenerModels = new LinkedList<EventListenerModel>();
    private EventListenerModel eventListenerModel;
    private final List<OsgiContextModel> newModels = new LinkedList<OsgiContextModel>();

    public EventListenerModelChange(OpCode op, EventListenerModel eventListenerModel, OsgiContextModel ... newModels) {
        super(op);
        this.eventListenerModels.add(eventListenerModel);
        this.eventListenerModel = eventListenerModel;
        this.newModels.addAll(Arrays.asList(newModels));
    }

    public EventListenerModelChange(OpCode op, List<EventListenerModel> eventListenerModels) {
        super(op);
        this.eventListenerModels.addAll(eventListenerModels);
    }

    public EventListenerModel getEventListenerModel() {
        return this.eventListenerModel;
    }

    public List<EventListenerModel> getEventListenerModels() {
        return this.eventListenerModels;
    }

    public boolean isDynamic() {
        return this.eventListenerModel != null && this.eventListenerModel.isDynamic();
    }

    public List<OsgiContextModel> getNewModels() {
        return this.newModels;
    }

    @Override
    public void uninstall(List<Change> operations) {
        if (this.getKind() == OpCode.ADD) {
            EventListener listener = this.eventListenerModel.getResolvedListener();
            operations.add(new EventListenerModelChange(OpCode.DELETE, this.eventListenerModel, new OsgiContextModel[0]));
        }
    }

    @Override
    public void accept(BatchVisitor visitor) {
        visitor.visitEventListenerModelChange(this);
    }

    @Override
    public List<OsgiContextModel> getContextModels() {
        return this.newModels.size() > 0 ? this.newModels : this.eventListenerModel.getContextModels();
    }

    public String toString() {
        EventListenerModel model = this.eventListenerModel;
        if (model == null && this.eventListenerModels.size() == 1) {
            model = this.eventListenerModels.get(0);
        }
        if (model != null) {
            return (Object)((Object)this.getKind()) + ": " + model;
        }
        return (Object)((Object)this.getKind()) + ": " + this.eventListenerModels.size() + " event listener models";
    }
}

