/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet.dynamic;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.servlet.DynamicRegistrations;

public class DynamicFilterRegistration
implements FilterRegistration.Dynamic {
    private final FilterModel model;
    private final OsgiContextModel osgiContextModel;
    private final DynamicRegistrations registrations;

    public DynamicFilterRegistration(FilterModel model, OsgiContextModel osgiContextModel, DynamicRegistrations regs) {
        this.model = model;
        this.model.getContextModels();
        this.osgiContextModel = osgiContextModel;
        this.registrations = regs;
    }

    public FilterModel getModel() {
        return this.model;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        this.model.addDynamicServletNameMapping(dispatcherTypes, servletNames, isMatchAfter);
    }

    public Collection<String> getServletNameMappings() {
        return this.model.getDynamicServletNames().stream().map(FilterModel.Mapping::getServletNames).flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        this.model.addDynamicUrlPatternMapping(dispatcherTypes, urlPatterns, isMatchAfter);
    }

    public Collection<String> getUrlPatternMappings() {
        return this.model.getDynamicUrlPatterns().stream().map(FilterModel.Mapping::getUrlPatterns).flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        this.model.setAsyncSupported(isAsyncSupported);
    }

    public String getName() {
        return this.model.getName();
    }

    public String getClassName() {
        return this.model.getActualClass().getName();
    }

    public boolean setInitParameter(String name, String value) {
        if (this.model.getInitParams().containsKey(name)) {
            return false;
        }
        this.model.getInitParams().put(name, value);
        return true;
    }

    public String getInitParameter(String name) {
        return this.model.getInitParams().get(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        LinkedHashSet<String> existingKeys = new LinkedHashSet<String>(this.model.getInitParams().keySet());
        existingKeys.retainAll(initParameters.keySet());
        this.model.getInitParams().putAll(initParameters);
        return existingKeys;
    }

    public Map<String, String> getInitParameters() {
        return this.model.getInitParams();
    }
}

