/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function.simplify;

import java.util.BitSet;
import java.util.function.Predicate;

final class CompositionTaskBitScanner {
    private final BitSet bitSet;

    private CompositionTaskBitScanner(BitSet bitSet) {
        this.bitSet = bitSet;
    }

    public static <T> CompositionTaskBitScanner of(T[] array, Predicate<T> bitTest) {
        BitSet mask = new BitSet(array.length);
        int bitIndex = 0;
        for (T element : array) {
            if (bitTest.test(element)) {
                mask.set(bitIndex);
            }
            ++bitIndex;
        }
        return new CompositionTaskBitScanner(mask);
    }

    public void visitBitSequences(BiIntConsumer visitor) {
        int nextSetBit;
        int scanPointer = 0;
        while ((nextSetBit = this.bitSet.nextSetBit(scanPointer)) > -1) {
            int nextClearBit = this.bitSet.nextClearBit(nextSetBit);
            if (nextClearBit == -1) {
                visitor.accept(nextSetBit, this.bitSet.size());
                return;
            }
            scanPointer = nextClearBit;
            visitor.accept(nextSetBit, nextClearBit);
        }
    }

    @FunctionalInterface
    public static interface BiIntConsumer {
        public void accept(int var1, int var2);
    }
}

