/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.JSONInputStream;

@NonNullByDefault
public class Stream2JSONInputStream
extends InputStream
implements JSONInputStream {
    private static final Gson GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
    private final InputStream stream;

    public Stream2JSONInputStream(Stream<?> source) {
        final Iterator iterator = source.map(e -> GSON.toJson(e)).iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){
            private boolean consumed = false;
            private @Nullable InputStream next = 1.toStream("[");

            @Override
            public boolean hasMoreElements() {
                return this.next != null || iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                if (this.next != null) {
                    InputStream is = this.next;
                    if (!this.consumed && !iterator.hasNext()) {
                        this.next = 1.toStream("]");
                        this.consumed = true;
                    } else {
                        this.next = null;
                    }
                    return is;
                }
                InputStream is = 1.toStream((String)iterator.next());
                if (iterator.hasNext()) {
                    this.next = 1.toStream(",");
                } else {
                    this.next = 1.toStream("]");
                    this.consumed = true;
                }
                return is;
            }

            private static InputStream toStream(String data) {
                return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            }
        };
        this.stream = new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(byte @Nullable [] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public long transferTo(OutputStream target) throws IOException {
        return this.stream.transferTo(target);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

