/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import java.lang.reflect.Array;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
class ImmutableElement<E>
implements ImmutableList<E> {
    @NotNull
    private final E element;

    @Contract(value="null -> fail")
    @NotNull
    static <E> ImmutableList<E> of(@Nullable E e) {
        return ImmutableElement.of(e, "Immutable list");
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    static <E> ImmutableList<E> of(@Nullable E e, @NotNull String name) {
        return new ImmutableElement<E>(Checks.elementNotNull(e, name, 0));
    }

    ImmutableElement(@NotNull E element) {
        this.element = element;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    @NotNull
    public E get(int index) {
        Checks.index(index, 1);
        return this.element;
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return new Object[]{this.element};
    }

    @Override
    public <T> T @NotNull [] toArray(T @Nullable [] other) {
        Checks.notNull(other, "Array");
        if (other.length < 1) {
            other = (Object[])Array.newInstance(other.getClass().getComponentType(), 1);
        } else if (other.length > 1) {
            other[1] = null;
        }
        other[0] = this.element;
        return other;
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return this.element.equals(o) ? 0 : -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.indexOf(o);
    }

    @Override
    @NotNull
    public ImmutableList.ImmutableListIterator<E> listIterator(int index) {
        return new ElementIterator(Checks.cursorIndex(index, 1));
    }

    @Override
    @NotNull
    public Spliterator<E> spliterator() {
        return new ElementSpliterator();
    }

    @Override
    public void forEach(@Nullable Consumer<? super E> consumer) {
        Checks.notNull(consumer, "Consumer");
        consumer.accept(this.element);
    }

    @Override
    @NotNull
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Checks.indexRange(fromIndex, toIndex, 1);
        return toIndex == fromIndex ? ImmutableList.of() : this;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List that = (List)o;
        return that.size() == 1 && this.element.equals(that.get(0));
    }

    @Override
    public int hashCode() {
        return 31 + this.element.hashCode();
    }

    @NotNull
    public String toString() {
        return "[" + this.element + "]";
    }

    private class ElementSpliterator
    implements Spliterator<E> {
        private int size = 1;

        private ElementSpliterator() {
        }

        @Override
        public boolean tryAdvance(@Nullable Consumer<? super E> consumer) {
            Checks.notNull(consumer, "Consumer");
            if (this.size == 1) {
                consumer.accept(ImmutableElement.this.element);
                this.size = 0;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Spliterator<E> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.size;
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.size;
        }

        @Override
        public int characteristics() {
            return 17745;
        }

        @Override
        public void forEachRemaining(@Nullable Consumer<? super E> consumer) {
            Checks.notNull(consumer, "Consumer");
            this.tryAdvance(consumer);
        }
    }

    private class ElementIterator
    implements ImmutableList.ImmutableListIterator<E> {
        private int index;

        ElementIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index == 0;
        }

        @Override
        @NotNull
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.index = 1;
            return ImmutableElement.this.element;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public boolean hasPrevious() {
            return this.index == 1;
        }

        @Override
        @NotNull
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.index = 0;
            return ImmutableElement.this.element;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void forEachRemaining(@Nullable Consumer<? super E> consumer) {
            Checks.notNull(consumer, "Consumer");
            if (this.hasNext()) {
                consumer.accept(this.next());
            }
        }
    }
}

