/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.impl;

import de.focus_shift.jollyday.core.CalendarHierarchy;
import de.focus_shift.jollyday.core.Holiday;
import de.focus_shift.jollyday.core.HolidayManager;
import de.focus_shift.jollyday.core.HolidayType;
import de.focus_shift.jollyday.core.caching.Cache;
import de.focus_shift.jollyday.core.parser.HolidayParser;
import de.focus_shift.jollyday.core.spi.Configuration;
import de.focus_shift.jollyday.core.spi.Holidays;
import de.focus_shift.jollyday.core.util.ClassLoadingUtil;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.Year;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHolidayManager
extends HolidayManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHolidayManager.class);
    private static final String PARSER_IMPL_PREFIX = "parser.impl.";
    private final Cache<HolidayParser> parserCache = new Cache();
    private final Cache<Set<Holiday>> holidayCache = new Cache();
    protected Configuration configuration;

    @Override
    public void doInit() {
        this.configuration = this.getConfigurationService().getConfiguration(this.getManagerParameter());
        DefaultHolidayManager.validateConfigurationHierarchy(this.configuration);
        DefaultHolidayManager.logHierarchy(this.configuration, 0);
    }

    @Override
    public Set<Holiday> getHolidays(int year, String ... args) {
        return this.getHolidays(Year.of(year), args);
    }

    @Override
    public Set<Holiday> getHolidays(final Year year, final String ... args) {
        final StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(year);
        for (String arg : args) {
            keyBuilder.append("_");
            keyBuilder.append(arg);
        }
        Cache.ValueHandler<Set<Holiday>> holidayValueHandler = new Cache.ValueHandler<Set<Holiday>>(){

            @Override
            public String getKey() {
                return keyBuilder.toString();
            }

            @Override
            public Set<Holiday> createValue() {
                Set<Holiday> holidaySet = Collections.synchronizedSet(new HashSet());
                DefaultHolidayManager.this.getHolidays(year, DefaultHolidayManager.this.configuration, holidaySet, args);
                return holidaySet;
            }
        };
        return this.holidayCache.get(holidayValueHandler);
    }

    @Override
    public Set<Holiday> getHolidays(int year, HolidayType holidayType, String ... args) {
        return this.getHolidays(Year.of(year), holidayType, args);
    }

    @Override
    public Set<Holiday> getHolidays(Year year, HolidayType holidayType, String ... args) {
        return this.getHolidays(year, args).stream().filter(holiday -> holiday.getType().equals((Object)holidayType)).collect(Collectors.toSet());
    }

    @Override
    public Set<Holiday> getHolidays(LocalDate startDateInclusive, LocalDate endDateInclusive, String ... args) {
        Objects.requireNonNull(startDateInclusive, "startDateInclusive is null");
        Objects.requireNonNull(endDateInclusive, "endDateInclusive is null");
        return IntStream.rangeClosed(startDateInclusive.getYear(), endDateInclusive.getYear()).mapToObj(year -> this.getHolidays(year, args)).flatMap(Collection::stream).filter(holiday -> !startDateInclusive.isAfter(holiday.getDate()) && !endDateInclusive.isBefore(holiday.getDate())).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<Holiday> getHolidays(LocalDate startDateInclusive, LocalDate endDateInclusive, HolidayType holidayType, String ... args) {
        return this.getHolidays(startDateInclusive, endDateInclusive, args).stream().filter(holiday -> holiday.getType().equals((Object)holidayType)).collect(Collectors.toSet());
    }

    @Override
    public CalendarHierarchy getCalendarHierarchy() {
        return DefaultHolidayManager.createConfigurationHierarchy(this.configuration, null);
    }

    private void getHolidays(Year year, Configuration configuration, Set<Holiday> holidaySet, String ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding holidays for {}", (Object)configuration.description());
        }
        this.parseHolidays(year, holidaySet, configuration.holidays());
        if (args != null && args.length > 0) {
            String hierarchy = args[0];
            configuration.subConfigurations().filter(sub -> hierarchy.equalsIgnoreCase(sub.hierarchy())).forEach(config -> this.getHolidays(year, (Configuration)config, holidaySet, Arrays.copyOfRange(args, 1, args.length)));
        }
    }

    private void parseHolidays(Year year, Set<Holiday> holidays, Holidays config) {
        this.getParsers(config).stream().map(holidayParser -> holidayParser.parse(year, config)).flatMap(Collection::stream).collect(Collectors.toCollection(() -> holidays));
    }

    private Collection<HolidayParser> getParsers(Holidays config) {
        HashSet<HolidayParser> parsers = new HashSet<HolidayParser>();
        try {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = config.getClass().getDeclaredMethods()) {
                HolidayParser holidayParser;
                if (!(declaredMethod.getGenericReturnType() instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)declaredMethod.getGenericReturnType();
                Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
                List holidays = (List)declaredMethod.invoke((Object)config, new Object[0]);
                if (holidays.isEmpty() || (holidayParser = this.instantiateParser(actualTypeArgument.getTypeName())) == null) continue;
                parsers.add(holidayParser);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create parsers.", e);
        }
        return parsers;
    }

    private HolidayParser instantiateParser(final String className) {
        Cache.ValueHandler<HolidayParser> parserValueHandler = new Cache.ValueHandler<HolidayParser>(){

            @Override
            public String getKey() {
                return className;
            }

            @Override
            public HolidayParser createValue() {
                String parserClassName = DefaultHolidayManager.this.getManagerParameter().getProperty(DefaultHolidayManager.PARSER_IMPL_PREFIX + className);
                if (parserClassName != null) {
                    try {
                        return (HolidayParser)ClassLoadingUtil.loadClass(parserClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException | SecurityException e) {
                        throw new IllegalStateException("Cannot create parsers.", e);
                    }
                }
                return null;
            }
        };
        return this.parserCache.get(parserValueHandler);
    }

    protected static void logHierarchy(Configuration configuration, int level) {
        if (LOG.isDebugEnabled()) {
            StringBuilder space = new StringBuilder();
            space.append("-".repeat(level));
            LOG.debug("{} {} ({}).", new Object[]{space, configuration.description(), configuration.hierarchy()});
            configuration.subConfigurations().forEach(config -> DefaultHolidayManager.logHierarchy(config, level + 1));
        }
    }

    protected static void validateConfigurationHierarchy(Configuration configuration) {
        HashMap hierarchyMap = new HashMap();
        HashSet multipleHierarchies = new HashSet();
        configuration.subConfigurations().forEach(subConfig -> {
            String hierarchy = subConfig.hierarchy();
            if (!hierarchyMap.containsKey(hierarchy)) {
                hierarchyMap.put(hierarchy, 1);
            } else {
                int count = (Integer)hierarchyMap.get(hierarchy);
                hierarchyMap.put(hierarchy, ++count);
                multipleHierarchies.add(hierarchy);
            }
        });
        if (!multipleHierarchies.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Configuration for ").append(configuration.hierarchy()).append(" contains  multiple SubConfigurations with the same hierarchy id. ");
            for (String hierarchy : multipleHierarchies) {
                msg.append(hierarchy).append(" ").append(((Integer)hierarchyMap.get(hierarchy)).toString()).append(" times ");
            }
            throw new IllegalArgumentException(msg.toString().trim());
        }
        configuration.subConfigurations().forEach(DefaultHolidayManager::validateConfigurationHierarchy);
    }

    private static CalendarHierarchy createConfigurationHierarchy(Configuration configuration, CalendarHierarchy calendarHierarchy) {
        CalendarHierarchy hierarchy = new CalendarHierarchy(calendarHierarchy, configuration.hierarchy());
        hierarchy.setFallbackDescription(configuration.description());
        configuration.subConfigurations().forEach(subConfiguration -> {
            CalendarHierarchy subHierarchy = DefaultHolidayManager.createConfigurationHierarchy(subConfiguration, hierarchy);
            hierarchy.getChildren().put(subHierarchy.getId(), subHierarchy);
        });
        return hierarchy;
    }
}

