/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core;

import de.focus_shift.jollyday.core.HolidayType;
import de.focus_shift.jollyday.core.util.ResourceUtil;
import java.time.LocalDate;
import java.util.Locale;

public final class Holiday
implements Comparable<Holiday> {
    private int hashCode = 0;
    private final LocalDate date;
    private final String propertiesKey;
    private final HolidayType type;

    public Holiday(LocalDate date, String propertiesKey, HolidayType type) {
        this.type = type;
        this.date = date;
        this.propertiesKey = propertiesKey == null ? "" : propertiesKey;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public String getPropertiesKey() {
        return this.propertiesKey;
    }

    public String getDescription() {
        return ResourceUtil.getHolidayDescription(Locale.getDefault(), this.getPropertiesKey());
    }

    public String getDescription(Locale locale) {
        return ResourceUtil.getHolidayDescription(locale, this.getPropertiesKey());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Holiday) {
            Holiday other = (Holiday)obj;
            return other.date.equals(this.date) && other.propertiesKey.equals(this.propertiesKey) && this.type.equals((Object)other.type);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 1;
            hash = hash * 31 + this.date.hashCode();
            hash = hash * 31 + this.propertiesKey.hashCode();
            this.hashCode = hash = hash * 31 + this.type.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.date.toString() + " (" + this.getDescription() + ")";
    }

    public HolidayType getType() {
        return this.type;
    }

    @Override
    public int compareTo(Holiday other) {
        return this.getDate().compareTo(other.getDate());
    }
}

