/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.profile;

import java.util.List;
import java.util.Optional;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.thing.profiles.ProfileCallback;
import org.openhab.core.thing.profiles.ProfileContext;
import org.openhab.core.thing.profiles.ProfileTypeUID;
import org.openhab.core.thing.profiles.TimeSeriesProfile;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationService;
import org.openhab.core.types.Command;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.Type;
import org.openhab.core.types.TypeParser;
import org.openhab.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ScriptProfile
implements TimeSeriesProfile {
    public static final String CONFIG_TO_ITEM_SCRIPT = "toItemScript";
    public static final String CONFIG_TO_HANDLER_SCRIPT = "toHandlerScript";
    public static final String CONFIG_COMMAND_FROM_ITEM_SCRIPT = "commandFromItemScript";
    public static final String CONFIG_STATE_FROM_ITEM_SCRIPT = "stateFromItemScript";
    private final Logger logger = LoggerFactory.getLogger(ScriptProfile.class);
    private final ProfileCallback callback;
    private final TransformationService transformationService;
    private final List<Class<? extends State>> acceptedDataTypes;
    private final List<Class<? extends Command>> acceptedCommandTypes;
    private final List<Class<? extends Command>> handlerAcceptedCommandTypes;
    private final String toItemScript;
    private final String commandFromItemScript;
    private final String stateFromItemScript;
    private final ProfileTypeUID profileTypeUID;
    private final boolean isConfigured;

    public ScriptProfile(ProfileTypeUID profileTypeUID, ProfileCallback callback, ProfileContext profileContext, TransformationService transformationService) {
        this.profileTypeUID = profileTypeUID;
        this.callback = callback;
        this.transformationService = transformationService;
        this.acceptedCommandTypes = profileContext.getAcceptedCommandTypes();
        this.acceptedDataTypes = profileContext.getAcceptedDataTypes();
        this.handlerAcceptedCommandTypes = profileContext.getHandlerAcceptedCommandTypes();
        this.toItemScript = (String)ConfigParser.valueAsOrElse((Object)profileContext.getConfiguration().get(CONFIG_TO_ITEM_SCRIPT), String.class, (Object)"");
        String toHandlerScript = (String)ConfigParser.valueAsOrElse((Object)profileContext.getConfiguration().get(CONFIG_TO_HANDLER_SCRIPT), String.class, (Object)"");
        String localCommandFromItemScript = (String)ConfigParser.valueAsOrElse((Object)profileContext.getConfiguration().get(CONFIG_COMMAND_FROM_ITEM_SCRIPT), String.class, (Object)"");
        this.commandFromItemScript = localCommandFromItemScript.isBlank() ? toHandlerScript : localCommandFromItemScript;
        this.stateFromItemScript = (String)ConfigParser.valueAsOrElse((Object)profileContext.getConfiguration().get(CONFIG_STATE_FROM_ITEM_SCRIPT), String.class, (Object)"");
        if (!toHandlerScript.isBlank() && localCommandFromItemScript.isBlank()) {
            this.logger.warn("'toHandlerScript' has been deprecated! Please use 'commandFromItemScript' instead in link '{}'.", (Object)callback.getItemChannelLink());
        }
        if (this.toItemScript.isBlank() && this.commandFromItemScript.isBlank() && this.stateFromItemScript.isBlank()) {
            this.logger.error("Neither 'toItemScript', 'commandFromItemScript' nor 'stateFromItemScript' defined in link '{}'. Profile will discard all states and commands.", (Object)callback.getItemChannelLink());
            this.isConfigured = false;
            return;
        }
        this.isConfigured = true;
    }

    public ProfileTypeUID getProfileTypeUID() {
        return this.profileTypeUID;
    }

    public void onStateUpdateFromItem(State state) {
        if (this.isConfigured) {
            this.fromItem(this.stateFromItemScript, (Type)state);
        }
    }

    public void onCommandFromItem(Command command) {
        if (this.isConfigured) {
            this.fromItem(this.commandFromItemScript, (Type)command);
        }
    }

    private void fromItem(String script, Type type) {
        String returnValue = this.executeScript(script, type);
        if (returnValue != null) {
            Command newCommand = TypeParser.parseCommand(this.handlerAcceptedCommandTypes, (String)returnValue);
            if (newCommand != null) {
                this.callback.handleCommand(newCommand);
            } else {
                this.logger.debug("The given type {} could not be transformed to a command", (Object)type);
            }
        }
    }

    public void onCommandFromHandler(Command command) {
        Command newCommand;
        String returnValue;
        if (this.isConfigured && (returnValue = this.executeScript(this.toItemScript, (Type)command)) != null && (newCommand = TypeParser.parseCommand(this.acceptedCommandTypes, (String)returnValue)) != null) {
            this.callback.sendCommand(newCommand);
        }
    }

    public void onStateUpdateFromHandler(State state) {
        if (this.isConfigured) {
            this.transformState(state).ifPresent(arg_0 -> ((ProfileCallback)this.callback).sendUpdate(arg_0));
        }
    }

    public void onTimeSeriesFromHandler(TimeSeries timeSeries) {
        if (this.isConfigured) {
            TimeSeries transformedTimeSeries = new TimeSeries(timeSeries.getPolicy());
            timeSeries.getStates().forEach(entry -> this.transformState(entry.state()).ifPresent(transformedState -> transformedTimeSeries.add(entry.timestamp(), transformedState)));
            if (transformedTimeSeries.size() > 0) {
                this.callback.sendTimeSeries(transformedTimeSeries);
            }
        }
    }

    private Optional<State> transformState(State state) {
        return Optional.ofNullable(this.executeScript(this.toItemScript, (Type)state)).map(output -> switch (output) {
            case "UNDEF" -> UnDefType.UNDEF;
            case "NULL" -> UnDefType.NULL;
            default -> TypeParser.parseState(this.acceptedDataTypes, (String)output);
        });
    }

    private @Nullable String executeScript(String script, Type input) {
        if (!script.isBlank()) {
            try {
                return this.transformationService.transform(script, input.toFullString());
            }
            catch (TransformationException e) {
                if (e.getCause() instanceof ScriptException) {
                    this.logger.error("Failed to process script '{}': {}", (Object)script, (Object)e.getCause().getMessage());
                }
                this.logger.error("Failed to process script '{}': {}", (Object)script, (Object)e.getMessage());
            }
        }
        return null;
    }
}

