/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.resolver;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.tasks.DNSTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DNSResolverTask
extends DNSTask {
    private static Logger logger = LoggerFactory.getLogger(DNSResolverTask.class);
    protected int _count = 0;

    public DNSResolverTask(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl);
    }

    @Override
    public String toString() {
        return super.toString() + " count: " + this._count;
    }

    @Override
    public void start(Timer timer) {
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, 225L, 225L);
        }
    }

    @Override
    public void run() {
        try {
            if (this.getDns().isCanceling() || this.getDns().isCanceled()) {
                this.cancel();
            } else if (this._count++ < 3) {
                logger.debug("{}.run() JmDNS {}", (Object)this.getName(), (Object)this.description());
                DNSOutgoing out = new DNSOutgoing(0);
                out = this.addQuestions(out);
                if (this.getDns().isAnnounced()) {
                    out = this.addAnswers(out);
                }
                if (!out.isEmpty()) {
                    this.getDns().send(out);
                }
            } else {
                this.cancel();
            }
        }
        catch (Throwable e) {
            logger.warn("{}.run() exception ", (Object)this.getName(), (Object)e);
            this.getDns().recover();
        }
    }

    protected abstract DNSOutgoing addQuestions(DNSOutgoing var1) throws IOException;

    protected abstract DNSOutgoing addAnswers(DNSOutgoing var1) throws IOException;

    protected abstract String description();
}

