/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.scoping;

import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.Set;
import org.openhab.core.library.types.IncreaseDecreaseType;
import org.openhab.core.library.types.NextPreviousType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.OpenClosedType;
import org.openhab.core.library.types.PlayPauseType;
import org.openhab.core.library.types.RewindFastforwardType;
import org.openhab.core.library.types.StopMoveType;
import org.openhab.core.library.types.UpDownType;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.Type;
import org.openhab.core.types.UnDefType;

@Singleton
public class StateAndCommandProvider {
    protected static final Set<Command> COMMANDS = new HashSet<Command>();
    protected static final Set<State> STATES = new HashSet<State>();
    protected static final Set<Type> TYPES = new HashSet<Type>();

    static {
        COMMANDS.add((Command)OnOffType.ON);
        COMMANDS.add((Command)OnOffType.OFF);
        COMMANDS.add((Command)UpDownType.UP);
        COMMANDS.add((Command)UpDownType.DOWN);
        COMMANDS.add((Command)IncreaseDecreaseType.INCREASE);
        COMMANDS.add((Command)IncreaseDecreaseType.DECREASE);
        COMMANDS.add((Command)StopMoveType.STOP);
        COMMANDS.add((Command)StopMoveType.MOVE);
        COMMANDS.add((Command)PlayPauseType.PLAY);
        COMMANDS.add((Command)PlayPauseType.PAUSE);
        COMMANDS.add((Command)NextPreviousType.NEXT);
        COMMANDS.add((Command)NextPreviousType.PREVIOUS);
        COMMANDS.add((Command)RewindFastforwardType.REWIND);
        COMMANDS.add((Command)RewindFastforwardType.FASTFORWARD);
        COMMANDS.add((Command)RefreshType.REFRESH);
        STATES.add((State)UnDefType.UNDEF);
        STATES.add((State)UnDefType.NULL);
        STATES.add((State)OnOffType.ON);
        STATES.add((State)OnOffType.OFF);
        STATES.add((State)UpDownType.UP);
        STATES.add((State)UpDownType.DOWN);
        STATES.add((State)OpenClosedType.OPEN);
        STATES.add((State)OpenClosedType.CLOSED);
        STATES.add((State)PlayPauseType.PLAY);
        STATES.add((State)PlayPauseType.PAUSE);
        STATES.add((State)RewindFastforwardType.REWIND);
        STATES.add((State)RewindFastforwardType.FASTFORWARD);
        TYPES.addAll(COMMANDS);
        TYPES.addAll(STATES);
    }

    public Iterable<Type> getAllTypes() {
        return TYPES;
    }

    public Iterable<Command> getAllCommands() {
        return COMMANDS;
    }

    public Iterable<State> getAllStates() {
        return STATES;
    }
}

