/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.features.command.completers.AllFeatureCompleter;
import org.apache.karaf.features.command.completers.FeatureVersionCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="feature", name="status", description="Get the feature's current status")
@Service
public class StatusCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="feature", description="Name of the feature.", required=true)
    @Completion(value=AllFeatureCompleter.class)
    String feature;
    @Argument(index=1, name="version", description="Optional version of the feature.")
    @Completion(value=FeatureVersionCompleter.class)
    String version;

    @Override
    protected void doExecute(FeaturesService admin) throws Exception {
        System.out.println(this.getState(admin));
    }

    private String getState(FeaturesService featuresService) throws Exception {
        String id = this.version == null ? featuresService.getFeature(this.feature).getId() : featuresService.getFeature(this.feature, this.version).getId();
        return featuresService.getState(id).name();
    }
}

