/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.addon.sddp;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.AddonDiscoveryMethod;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonMatchProperty;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.config.discovery.addon.AddonFinder;
import org.openhab.core.config.discovery.addon.BaseAddonFinder;
import org.openhab.core.config.discovery.sddp.SddpDevice;
import org.openhab.core.config.discovery.sddp.SddpDeviceParticipant;
import org.openhab.core.config.discovery.sddp.SddpDiscoveryService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AddonFinder.class}, name="sddp-addon-suggestion-finder")
public class SddpAddonFinder
extends BaseAddonFinder
implements SddpDeviceParticipant {
    public static final String SERVICE_TYPE = "sddp";
    public static final String SERVICE_NAME = "sddp-addon-suggestion-finder";
    private static final String DRIVER = "driver";
    private static final String HOST = "host";
    private static final String IP_ADDRESS = "ipAddress";
    private static final String MAC_ADDRESS = "macAddress";
    private static final String MANUFACTURER = "manufacturer";
    private static final String MODEL = "model";
    private static final String PORT = "port";
    private static final String PRIMARY_PROXY = "primaryProxy";
    private static final String PROXIES = "proxies";
    private static final String TYPE = "type";
    private static final Set<String> SUPPORTED_PROPERTIES = Set.of("driver", "host", "ipAddress", "macAddress", "manufacturer", "model", "port", "primaryProxy", "proxies", "type");
    private final Logger logger = LoggerFactory.getLogger(SddpAddonFinder.class);
    private final Set<SddpDevice> foundDevices = new HashSet<SddpDevice>();
    private @Nullable SddpDiscoveryService sddpDiscoveryService = null;

    /*
     * WARNING - void declaration
     */
    @Activate
    public SddpAddonFinder(@Reference(service=DiscoveryService.class, target="(protocol=sddp)") DiscoveryService discoveryService) {
        DiscoveryService discoveryService2 = discoveryService;
        if (discoveryService2 instanceof SddpDiscoveryService) {
            void sddpDiscoveryService;
            SddpDiscoveryService sddpDiscoveryService2 = (SddpDiscoveryService)discoveryService2;
            SddpDiscoveryService cfr_ignored_0 = (SddpDiscoveryService)discoveryService2;
            sddpDiscoveryService.addSddpDeviceParticipant((SddpDeviceParticipant)this);
            this.sddpDiscoveryService = sddpDiscoveryService;
        } else {
            this.logger.warn("SddpAddonFinder() DiscoveryService is not an SddpDiscoveryService");
        }
    }

    @Deactivate
    public void deactivate() {
        SddpDiscoveryService sddpDiscoveryService = this.sddpDiscoveryService;
        if (sddpDiscoveryService != null) {
            sddpDiscoveryService.removeSddpDeviceParticipant((SddpDeviceParticipant)this);
            this.sddpDiscoveryService = null;
        }
        this.unsetAddonCandidates();
        this.foundDevices.clear();
    }

    public void deviceAdded(SddpDevice device) {
        this.foundDevices.add(device);
    }

    public void deviceRemoved(SddpDevice device) {
        this.foundDevices.remove(device);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public Set<AddonInfo> getSuggestedAddons() {
        HashSet<AddonInfo> result = new HashSet<AddonInfo>();
        block0: for (AddonInfo candidate : this.addonCandidates) {
            block1: for (AddonDiscoveryMethod method2 : candidate.getDiscoveryMethods().stream().filter(method -> SERVICE_TYPE.equals(method.getServiceType())).toList()) {
                Map<String, Pattern> matchProperties = method2.getMatchProperties().stream().collect(Collectors.toMap(AddonMatchProperty::getName, AddonMatchProperty::getPattern));
                HashSet<String> propertyNames = new HashSet<String>(matchProperties.keySet());
                propertyNames.removeAll(SUPPORTED_PROPERTIES);
                if (!propertyNames.isEmpty()) {
                    this.logger.warn("Add-on '{}' addon.xml file contains unsupported 'match-property' [{}]", (Object)candidate.getUID(), (Object)String.join((CharSequence)",", propertyNames));
                    continue block0;
                }
                this.logger.trace("Checking candidate: {}", (Object)candidate.getUID());
                for (SddpDevice device : this.foundDevices) {
                    this.logger.trace("Checking device: {}", (Object)device.host);
                    if (!SddpAddonFinder.propertyMatches(matchProperties, (String)HOST, (String)device.host) || !SddpAddonFinder.propertyMatches(matchProperties, (String)IP_ADDRESS, (String)device.ipAddress) || !SddpAddonFinder.propertyMatches(matchProperties, (String)MAC_ADDRESS, (String)device.macAddress) || !SddpAddonFinder.propertyMatches(matchProperties, (String)MANUFACTURER, (String)device.manufacturer) || !SddpAddonFinder.propertyMatches(matchProperties, (String)MODEL, (String)device.model) || !SddpAddonFinder.propertyMatches(matchProperties, (String)PORT, (String)device.port) || !SddpAddonFinder.propertyMatches(matchProperties, (String)PRIMARY_PROXY, (String)device.primaryProxy) || !SddpAddonFinder.propertyMatches(matchProperties, (String)PROXIES, (String)device.proxies) || !SddpAddonFinder.propertyMatches(matchProperties, (String)TYPE, (String)device.type)) continue;
                    result.add(candidate);
                    this.logger.debug("Suggested add-on found: {}", (Object)candidate.getUID());
                    continue block1;
                }
            }
        }
        return result;
    }

    public void setAddonCandidates(List<AddonInfo> candidates) {
        super.setAddonCandidates(candidates);
    }
}

