/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.service;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public interface WatchService {
    public static final String SERVICE_PID = "org.openhab.core.service.WatchService";
    public static final String SERVICE_PROPERTY_DIR = "watchservice.dir";
    public static final String SERVICE_PROPERTY_NAME = "watchservice.name";
    public static final String CONFIG_WATCHER_NAME = "configWatcher";
    public static final String CONFIG_WATCHER_FILTER = "(watchservice.name=configWatcher)";

    default public void registerListener(WatchEventListener watchEventListener, Path path) {
        this.registerListener(watchEventListener, List.of(path), true);
    }

    default public void registerListener(WatchEventListener watchEventListener, List<Path> paths) {
        this.registerListener(watchEventListener, paths, true);
    }

    default public void registerListener(WatchEventListener watchEventListener, Path path, boolean withSubDirectories) {
        this.registerListener(watchEventListener, List.of(path), withSubDirectories);
    }

    public void registerListener(WatchEventListener var1, List<Path> var2, boolean var3);

    public void unregisterListener(WatchEventListener var1);

    public Path getWatchPath();

    public static enum Kind {
        CREATE,
        MODIFY,
        DELETE,
        OVERFLOW;

    }

    @FunctionalInterface
    public static interface WatchEventListener {
        public void processWatchEvent(Kind var1, Path var2);
    }
}

