/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.PskSecretResultHandler;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCryptoMap;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalMac;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;

@Deprecated
public class AdvancedInMemoryPskStore
implements AdvancedPskStore {
    protected static final ThreadLocalCryptoMap<ThreadLocalMac> MAC = new ThreadLocalCryptoMap<ThreadLocalMac>(new ThreadLocalCryptoMap.Factory<ThreadLocalMac>(){

        @Override
        public ThreadLocalMac getInstance(String algorithm) {
            return new ThreadLocalMac(algorithm);
        }
    });
    protected final PskStore pskStore;

    public AdvancedInMemoryPskStore(PskStore pskStore) {
        if (pskStore == null) {
            throw new NullPointerException("PSK store must not be null!");
        }
        this.pskStore = pskStore;
    }

    @Override
    public boolean hasEcdhePskSupported() {
        return true;
    }

    @Override
    public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverNames, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed) {
        SecretKey secret;
        SecretKey secretKey = secret = serverNames != null ? this.pskStore.getKey(serverNames, identity) : this.pskStore.getKey(identity);
        if (secret != null) {
            SecretKey masterSecret = this.generateMasterSecret(hmacAlgorithm, secret, otherSecret, seed);
            SecretUtil.destroy(secret);
            secret = masterSecret;
        }
        return new PskSecretResult(cid, identity, secret);
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        return virtualHost != null ? this.pskStore.getIdentity(peerAddress, virtualHost) : this.pskStore.getIdentity(peerAddress);
    }

    @Override
    public void setResultHandler(PskSecretResultHandler resultHandler) {
    }

    protected SecretKey generateMasterSecret(String hmacAlgorithm, SecretKey pskSecret, SecretKey otherSecret, byte[] seed) {
        ThreadLocalMac hmac = MAC.get(hmacAlgorithm);
        SecretKey premasterSecret = PseudoRandomFunction.generatePremasterSecretFromPSK(otherSecret, pskSecret);
        SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret((Mac)hmac.current(), premasterSecret, seed);
        SecretUtil.destroy(premasterSecret);
        return masterSecret;
    }
}

