/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCrypto;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCryptoMap;

public class ThreadLocalKeyFactory
extends ThreadLocalCrypto<KeyFactory> {
    public static final ThreadLocalCryptoMap<ThreadLocalKeyFactory> KEY_FACTORIES = new ThreadLocalCryptoMap<ThreadLocalKeyFactory>(new ThreadLocalCryptoMap.Factory<ThreadLocalKeyFactory>(){

        @Override
        public ThreadLocalKeyFactory getInstance(String algorithm) {
            return new ThreadLocalKeyFactory(algorithm);
        }
    });

    public ThreadLocalKeyFactory(final String algorithm) {
        super(new ThreadLocalCrypto.Factory<KeyFactory>(){

            @Override
            public KeyFactory getInstance() throws GeneralSecurityException {
                String oid = Asn1DerDecoder.getEdDsaStandardAlgorithmName((String)algorithm, (String)algorithm);
                return KeyFactory.getInstance(oid);
            }
        });
    }
}

