/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.spi;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.verifier.VerifierPlugin;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SPIDescriptorGenerator
implements VerifierPlugin {
    @Override
    public void verify(Analyzer analyzer) throws Exception {
        Parameters provideCapabilities = new Parameters(analyzer.getJar().getManifest().getMainAttributes().getValue("Provide-Capability"), analyzer, true);
        HashMap providerTypes = new HashMap();
        provideCapabilities.stream().filterKey(key -> Processor.removeDuplicateMarker(key).equals("osgi.serviceloader")).values().forEachOrdered(attrs -> {
            String serviceImpl = attrs.get("register:");
            if (serviceImpl == null) {
                analyzer.warning("osgi.serviceloader capability found with no 'register:' directive. Descriptor cannot be managed for osgi.serviceloader;%s", attrs);
            } else {
                String serviceType = attrs.get("osgi.serviceloader");
                providerTypes.computeIfAbsent(serviceType, k -> new ArrayList()).add(serviceImpl);
            }
        });
        for (Map.Entry entry : providerTypes.entrySet()) {
            String key2 = "META-INF/services/" + (String)entry.getKey();
            ArrayList list = (ArrayList)entry.getValue();
            Resource resource = analyzer.getJar().getResource(key2);
            String value = "";
            if (resource != null) {
                value = IO.collect(resource.openInputStream());
                try (BufferedReader br = new BufferedReader(new StringReader(value));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                        list.remove(line);
                    }
                }
            }
            if (list.isEmpty()) continue;
            list.add(0, "# Generated by bnd");
            if (!value.isEmpty()) {
                value = value + "\n\n";
            }
            value = value + Strings.join("\n", list);
            analyzer.getJar().putResource(key2, new EmbeddedResource(value, analyzer.lastModified()));
        }
    }
}

