/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.rest.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.dto.ActionTypeDTOMapper;
import org.openhab.core.automation.dto.ConditionTypeDTOMapper;
import org.openhab.core.automation.dto.ModuleTypeDTO;
import org.openhab.core.automation.dto.TriggerTypeDTOMapper;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.CompositeActionType;
import org.openhab.core.automation.type.CompositeConditionType;
import org.openhab.core.automation.type.CompositeTriggerType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.openhab.core.automation.type.TriggerType;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="module-types")
@Tag(name="module-types")
@Component
@JaxrsResource
@JaxrsName(value="module-types")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ModuleTypeResource
implements RESTResource {
    public static final String PATH_MODULE_TYPES = "module-types";
    private final LocaleService localeService;
    private final ModuleTypeRegistry moduleTypeRegistry;

    @Activate
    public ModuleTypeResource(@Reference LocaleService localeService, @Reference ModuleTypeRegistry moduleTypeRegistry) {
        this.localeService = localeService;
        this.moduleTypeRegistry = moduleTypeRegistry;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getModuleTypes", summary="Get all available module types.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ModuleTypeDTO.class)))})})
    public Response getAll(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="tags") @Parameter(description="tags for filtering") @Nullable String tagList, @QueryParam(value="type") @Parameter(description="filtering by action, condition or trigger") @Nullable String type) {
        Locale locale = this.localeService.getLocale(language);
        String[] tags = tagList != null ? tagList.split(",") : new String[]{};
        ArrayList modules = new ArrayList();
        if (type == null || "trigger".equals(type)) {
            modules.addAll(TriggerTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getTriggers(locale, tags)));
        }
        if (type == null || "condition".equals(type)) {
            modules.addAll(ConditionTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getConditions(locale, tags)));
        }
        if (type == null || "action".equals(type)) {
            modules.addAll(ActionTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getActions(locale, tags)));
        }
        return Response.ok(modules).build();
    }

    @GET
    @Path(value="/{moduleTypeUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="getModuleTypeById", summary="Gets a module type corresponding to the given UID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ModuleTypeDTO.class))}), @ApiResponse(responseCode="404", description="Module Type corresponding to the given UID does not found.")})
    public Response getByUID(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="moduleTypeUID") @Parameter(description="moduleTypeUID") String moduleTypeUID) {
        Locale locale = this.localeService.getLocale(language);
        ModuleType moduleType = this.moduleTypeRegistry.get(moduleTypeUID, locale);
        if (moduleType != null) {
            return Response.ok((Object)this.getModuleTypeDTO(moduleType)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    /*
     * WARNING - void declaration
     */
    private ModuleTypeDTO getModuleTypeDTO(ModuleType moduleType) {
        ModuleType moduleType2 = moduleType;
        if (moduleType2 instanceof ActionType) {
            void actionType;
            ActionType actionType2 = (ActionType)moduleType2;
            ActionType cfr_ignored_0 = (ActionType)moduleType2;
            ModuleType moduleType3 = moduleType;
            if (moduleType3 instanceof CompositeActionType) {
                void compositeActionType;
                CompositeActionType compositeActionType2 = (CompositeActionType)moduleType3;
                CompositeActionType cfr_ignored_1 = (CompositeActionType)moduleType3;
                return ActionTypeDTOMapper.map((CompositeActionType)compositeActionType);
            }
            return ActionTypeDTOMapper.map((ActionType)actionType);
        }
        ModuleType moduleType4 = moduleType;
        if (moduleType4 instanceof ConditionType) {
            void conditionType;
            ConditionType compositeActionType = (ConditionType)moduleType4;
            ConditionType cfr_ignored_2 = (ConditionType)moduleType4;
            ModuleType moduleType5 = moduleType;
            if (moduleType5 instanceof CompositeConditionType) {
                void compositeConditionType;
                CompositeConditionType compositeConditionType2 = (CompositeConditionType)moduleType5;
                CompositeConditionType cfr_ignored_3 = (CompositeConditionType)moduleType5;
                return ConditionTypeDTOMapper.map((CompositeConditionType)compositeConditionType);
            }
            return ConditionTypeDTOMapper.map((ConditionType)conditionType);
        }
        ModuleType moduleType6 = moduleType;
        if (moduleType6 instanceof TriggerType) {
            void triggerType;
            TriggerType compositeConditionType = (TriggerType)moduleType6;
            TriggerType cfr_ignored_4 = (TriggerType)moduleType6;
            ModuleType moduleType7 = moduleType;
            if (moduleType7 instanceof CompositeTriggerType) {
                void compositeTriggerType;
                CompositeTriggerType compositeTriggerType2 = (CompositeTriggerType)moduleType7;
                CompositeTriggerType cfr_ignored_5 = (CompositeTriggerType)moduleType7;
                return TriggerTypeDTOMapper.map((CompositeTriggerType)compositeTriggerType);
            }
            return TriggerTypeDTOMapper.map((TriggerType)triggerType);
        }
        throw new IllegalArgumentException(String.format("Cannot handle given module type class (%s)", moduleType.getClass()));
    }
}

