/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.network.stack.CleanupMessageObserver;
import org.eclipse.californium.core.network.stack.MulticastCleanupMessageObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeCleanupLayer
extends AbstractLayer {
    static final Logger LOGGER = LoggerFactory.getLogger(ExchangeCleanupLayer.class);
    private final int multicastLifetime;

    public ExchangeCleanupLayer(NetworkConfig config) {
        this.multicastLifetime = config.getInt("NON_LIFETIME") + config.getInt("MAX_LATENCY") + config.getInt("MAX_SERVER_RESPONSE_DELAY");
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        if (request.isMulticast()) {
            request.addMessageObserver(new MulticastCleanupMessageObserver(exchange, this.executor, this.multicastLifetime));
        } else {
            request.addMessageObserver(new CleanupMessageObserver(exchange));
        }
        super.sendRequest(exchange, request);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        CoAP.Type type;
        if (!(response.isNotification() || (type = response.getType()) != null && type != CoAP.Type.CON)) {
            response.addMessageObserver(new CleanupMessageObserver(exchange));
        }
        super.sendResponse(exchange, response);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (!exchange.getRequest().isMulticast()) {
            exchange.setComplete();
            exchange.getRequest().onComplete();
        }
        super.receiveResponse(exchange, response);
    }
}

