/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.californium.core.network.config.NetworkConfigDefaultHandler;
import org.eclipse.californium.core.network.config.NetworkConfigDefaults;
import org.eclipse.californium.core.network.config.NetworkConfigObserver;
import org.eclipse.californium.elements.util.NotForAndroid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkConfig.class);
    public static final String DEFAULT_FILE_NAME = "Californium.properties";
    public static final String DEFAULT_HEADER = "Californium CoAP Properties file";
    private static NetworkConfig standard;
    private Properties properties;
    private List<NetworkConfigObserver> observers = new LinkedList<NetworkConfigObserver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkConfig getStandard() {
        Class<NetworkConfig> clazz = NetworkConfig.class;
        synchronized (NetworkConfig.class) {
            if (standard == null) {
                NetworkConfig.createStandardWithFile(new File(DEFAULT_FILE_NAME));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return standard;
        }
    }

    public static void setStandard(NetworkConfig standard) {
        NetworkConfig.standard = standard;
    }

    public static NetworkConfig createStandardWithoutFile() {
        LOGGER.info("Creating standard network configuration properties without a file");
        standard = new NetworkConfig();
        return standard;
    }

    public static NetworkConfig createStandardFromStream(InputStream inStream) {
        standard = NetworkConfig.createFromStream(inStream, null);
        return standard;
    }

    public static NetworkConfig createFromStream(InputStream inStream, NetworkConfigDefaultHandler customHandler) {
        LOGGER.info("Creating network configuration properties from stream");
        NetworkConfig standard = new NetworkConfig();
        if (customHandler != null) {
            customHandler.applyDefaults(standard);
        }
        try {
            standard.load(inStream);
        }
        catch (IOException e) {
            LOGGER.warn("cannot load properties from stream: {}", (Object)e.getMessage());
        }
        return standard;
    }

    @NotForAndroid
    public static NetworkConfig createStandardWithFile(File file) {
        standard = NetworkConfig.createWithFile(file, DEFAULT_HEADER, null);
        return standard;
    }

    @NotForAndroid
    public static NetworkConfig createWithFile(File file, String header, NetworkConfigDefaultHandler customHandler) {
        NetworkConfig standard = new NetworkConfig();
        if (customHandler != null) {
            customHandler.applyDefaults(standard);
        }
        if (file.exists()) {
            standard.load(file);
        } else {
            standard.store(file, header);
        }
        return standard;
    }

    public NetworkConfig() {
        this.properties = new Properties();
        NetworkConfigDefaults.setDefaults(this);
    }

    public NetworkConfig(NetworkConfig config) {
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)config.properties);
    }

    @NotForAndroid
    public void load(File file) {
        if (file == null) {
            throw new NullPointerException("file must not be null");
        }
        LOGGER.info("loading properties from file {}", (Object)file.getAbsolutePath());
        try (FileInputStream inStream = new FileInputStream(file);){
            this.load(inStream);
        }
        catch (IOException e) {
            LOGGER.warn("cannot load properties from file {}: {}", new Object[]{file.getAbsolutePath(), e.getMessage()});
        }
    }

    public void load(InputStream inStream) throws IOException {
        if (inStream == null) {
            throw new NullPointerException("input stream must not be null");
        }
        this.properties.load(inStream);
    }

    @NotForAndroid
    public void store(File file) {
        this.store(file, DEFAULT_HEADER);
    }

    @NotForAndroid
    public void store(File file, String header) {
        if (file == null) {
            throw new NullPointerException("file must not be null");
        }
        LOGGER.info("writing properties to file {}", (Object)file.getAbsolutePath());
        try (FileWriter writer = new FileWriter(file);){
            this.properties.store(writer, header);
        }
        catch (IOException e) {
            LOGGER.warn("cannot write properties to file {}: {}", new Object[]{file.getAbsolutePath(), e.getMessage()});
        }
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public String getString(String key, String defaultValue) {
        String result = this.properties.getProperty(key);
        return result != null ? result : defaultValue;
    }

    public Integer getOptInteger(String key) {
        return this.getNumberValue(new PropertyParser<Integer>(){

            @Override
            public String getTypeName() {
                return "Integer";
            }

            @Override
            public Integer parseValue(String value) {
                return Integer.parseInt(value);
            }
        }, key, null);
    }

    public Long getOptLong(String key) {
        return this.getNumberValue(new PropertyParser<Long>(){

            @Override
            public String getTypeName() {
                return "Long";
            }

            @Override
            public Long parseValue(String value) {
                return Long.parseLong(value);
            }
        }, key, null);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        return this.getNumberValue(new PropertyParser<Integer>(){

            @Override
            public String getTypeName() {
                return "int";
            }

            @Override
            public Integer parseValue(String value) {
                return Integer.parseInt(value);
            }
        }, key, defaultValue);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        return this.getNumberValue(new PropertyParser<Long>(){

            @Override
            public String getTypeName() {
                return "long";
            }

            @Override
            public Long parseValue(String value) {
                return Long.parseLong(value);
            }
        }, key, defaultValue);
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getNumberValue(new PropertyParser<Float>(){

            @Override
            public String getTypeName() {
                return "float";
            }

            @Override
            public Float parseValue(String value) {
                return Float.valueOf(Float.parseFloat(value));
            }
        }, key, Float.valueOf(defaultValue)).floatValue();
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        return this.getNumberValue(new PropertyParser<Double>(){

            @Override
            public String getTypeName() {
                return "double";
            }

            @Override
            public Double parseValue(String value) {
                return Double.parseDouble(value);
            }
        }, key, defaultValue);
    }

    private <T> T getNumberValue(PropertyParser<T> parser, String key, T defaultValue) {
        T result = defaultValue;
        String value = this.properties.getProperty(key);
        if (value == null) {
            LOGGER.debug("key [{}] is undefined, returning default value", (Object)key);
        } else if (value.isEmpty()) {
            LOGGER.debug("key [{}] is empty, returning default value", (Object)key);
        }
        try {
            result = parser.parseValue(value);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("value for key [{}] is not a {}, returning default value", (Object)key, (Object)parser.getTypeName());
        }
        return result;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        LOGGER.warn("Key [{}] is undefined, returning defaultValue", (Object)key);
        return defaultValue;
    }

    public boolean getBoolean(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        LOGGER.warn("Key [{}] is undefined", (Object)key);
        return false;
    }

    public NetworkConfig set(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setString(String key, String value) {
        return this.set(key, value);
    }

    public NetworkConfig setInt(String key, int value) {
        return this.set(key, String.valueOf(value));
    }

    public NetworkConfig setLong(String key, long value) {
        return this.set(key, String.valueOf(value));
    }

    public NetworkConfig setFloat(String key, float value) {
        return this.set(key, String.valueOf(value));
    }

    public NetworkConfig setDouble(String key, double value) {
        return this.set(key, String.valueOf(value));
    }

    public NetworkConfig setBoolean(String key, boolean value) {
        return this.set(key, String.valueOf(value));
    }

    public NetworkConfig addConfigObserver(NetworkConfigObserver observer) {
        this.observers.add(observer);
        return this;
    }

    public NetworkConfig removeConfigObserver(NetworkConfigObserver observer) {
        this.observers.remove(observer);
        return this;
    }

    private static interface PropertyParser<T> {
        public String getTypeName();

        public T parseValue(String var1);
    }

    public class Keys {
        public static final String MAX_ACTIVE_PEERS = "MAX_ACTIVE_PEERS";
        public static final String MAX_PEER_INACTIVITY_PERIOD = "MAX_PEER_INACTIVITY_PERIOD";
        public static final String COAP_PORT = "COAP_PORT";
        public static final String COAP_SECURE_PORT = "COAP_SECURE_PORT";
        public static final String ACK_TIMEOUT = "ACK_TIMEOUT";
        public static final String ACK_RANDOM_FACTOR = "ACK_RANDOM_FACTOR";
        public static final String ACK_TIMEOUT_SCALE = "ACK_TIMEOUT_SCALE";
        public static final String MAX_RETRANSMIT = "MAX_RETRANSMIT";
        public static final String EXCHANGE_LIFETIME = "EXCHANGE_LIFETIME";
        public static final String NON_LIFETIME = "NON_LIFETIME";
        public static final String MAX_TRANSMIT_WAIT = "MAX_TRANSMIT_WAIT";
        public static final String MAX_LATENCY = "MAX_LATENCY";
        public static final String MAX_SERVER_RESPONSE_DELAY = "MAX_SERVER_RESPONSE_DELAY";
        public static final String NSTART = "NSTART";
        public static final String LEISURE = "LEISURE";
        public static final String PROBING_RATE = "PROBING_RATE";
        public static final String USE_MESSAGE_OFFLOADING = "USE_MESSAGE_OFFLOADING";
        public static final String USE_RANDOM_MID_START = "USE_RANDOM_MID_START";
        public static final String MID_TRACKER = "MID_TACKER";
        public static final String MID_TRACKER_GROUPS = "MID_TRACKER_GROUPS";
        public static final String MULTICAST_BASE_MID = "MULTICAST_BASE_MID";
        public static final String TOKEN_SIZE_LIMIT = "TOKEN_SIZE_LIMIT";
        public static final String PREFERRED_BLOCK_SIZE = "PREFERRED_BLOCK_SIZE";
        public static final String MAX_MESSAGE_SIZE = "MAX_MESSAGE_SIZE";
        public static final String MAX_RESOURCE_BODY_SIZE = "MAX_RESOURCE_BODY_SIZE";
        public static final String BLOCKWISE_STATUS_LIFETIME = "BLOCKWISE_STATUS_LIFETIME";
        public static final String BLOCKWISE_STRICT_BLOCK2_OPTION = "BLOCKWISE_STRICT_BLOCK2_OPTION";
        public static final String BLOCKWISE_ENTITY_TOO_LARGE_AUTO_FAILOVER = "BLOCKWISE_ENTITY_TOO_LARGE_AUTO_FAILOVER";
        public static final String NOTIFICATION_CHECK_INTERVAL_TIME = "NOTIFICATION_CHECK_INTERVAL";
        public static final String NOTIFICATION_CHECK_INTERVAL_COUNT = "NOTIFICATION_CHECK_INTERVAL_COUNT";
        public static final String NOTIFICATION_REREGISTRATION_BACKOFF = "NOTIFICATION_REREGISTRATION_BACKOFF";
        public static final String USE_CONGESTION_CONTROL = "USE_CONGESTION_CONTROL";
        public static final String CONGESTION_CONTROL_ALGORITHM = "CONGESTION_CONTROL_ALGORITHM";
        public static final String PROTOCOL_STAGE_THREAD_COUNT = "PROTOCOL_STAGE_THREAD_COUNT";
        public static final String NETWORK_STAGE_RECEIVER_THREAD_COUNT = "NETWORK_STAGE_RECEIVER_THREAD_COUNT";
        public static final String NETWORK_STAGE_SENDER_THREAD_COUNT = "NETWORK_STAGE_SENDER_THREAD_COUNT";
        public static final String UDP_CONNECTOR_DATAGRAM_SIZE = "UDP_CONNECTOR_DATAGRAM_SIZE";
        public static final String UDP_CONNECTOR_RECEIVE_BUFFER = "UDP_CONNECTOR_RECEIVE_BUFFER";
        public static final String UDP_CONNECTOR_SEND_BUFFER = "UDP_CONNECTOR_SEND_BUFFER";
        public static final String UDP_CONNECTOR_OUT_CAPACITY = "UDP_CONNECTOR_OUT_CAPACITY";
        public static final String DEDUPLICATOR = "DEDUPLICATOR";
        public static final String DEDUPLICATOR_MARK_AND_SWEEP = "DEDUPLICATOR_MARK_AND_SWEEP";
        public static final String DEDUPLICATOR_PEERS_MARK_AND_SWEEP = "DEDUPLICATOR_PEERS_MARK_AND_SWEEP";
        public static final String MARK_AND_SWEEP_INTERVAL = "MARK_AND_SWEEP_INTERVAL";
        public static final String PEERS_MARK_AND_SWEEP_MESSAGES = "PEERS_MARK_AND_SWEEP_MESSAGES";
        public static final String DEDUPLICATOR_CROP_ROTATION = "DEDUPLICATOR_CROP_ROTATION";
        public static final String CROP_ROTATION_PERIOD = "CROP_ROTATION_PERIOD";
        public static final String NO_DEDUPLICATOR = "NO_DEDUPLICATOR";
        public static final String DEDUPLICATOR_AUTO_REPLACE = "DEDUPLICATOR_AUTO_REPLACE";
        public static final String RESPONSE_MATCHING = "RESPONSE_MATCHING";
        public static final String HTTP_PORT = "HTTP_PORT";
        public static final String HTTP_SERVER_SOCKET_TIMEOUT = "HTTP_SERVER_SOCKET_TIMEOUT";
        public static final String HTTP_SERVER_SOCKET_BUFFER_SIZE = "HTTP_SERVER_SOCKET_BUFFER_SIZE";
        public static final String HTTP_CACHE_RESPONSE_MAX_AGE = "HTTP_CACHE_RESPONSE_MAX_AGE";
        public static final String HTTP_CACHE_SIZE = "HTTP_CACHE_SIZE";
        public static final String HEALTH_STATUS_INTERVAL = "HEALTH_STATUS_INTERVAL";
        public static final String TCP_CONNECTION_IDLE_TIMEOUT = "TCP_CONNECTION_IDLE_TIMEOUT";
        public static final String TCP_CONNECT_TIMEOUT = "TCP_CONNECT_TIMEOUT";
        public static final String TCP_WORKER_THREADS = "TCP_WORKER_THREADS";
        public static final String TLS_HANDSHAKE_TIMEOUT = "TLS_HANDSHAKE_TIMEOUT";
        public static final String SECURE_SESSION_TIMEOUT = "SECURE_SESSION_TIMEOUT";
        public static final String DTLS_AUTO_RESUME_TIMEOUT = "DTLS_AUTO_RESUME_TIMEOUT";
        public static final String DTLS_CONNECTION_ID_LENGTH = "DTLS_CONNECTION_ID_LENGTH";
        public static final String DTLS_CONNECTION_ID_NODE_ID = "DTLS_CONNECTION_ID_NODE_ID";
    }
}

